package com.instabug.library.model.v3Session

import androidx.annotation.IntDef
import com.instabug.library.model.v3Session.CustomStoreRattingMode.Companion.INVOKED_AND_REDIRECTED_TO_STORE
import com.instabug.library.model.v3Session.CustomStoreRattingMode.Companion.INVOKED_ONLY
import com.instabug.library.model.v3Session.CustomStoreRattingMode.Companion.NOT_INVOKED

@IntDef(value = [NOT_INVOKED, INVOKED_AND_REDIRECTED_TO_STORE, INVOKED_ONLY])
@Retention(AnnotationRetention.RUNTIME)
annotation class CustomStoreRattingMode {
    companion object {
        const val NOT_INVOKED = 0
        const val INVOKED_AND_REDIRECTED_TO_STORE = 1
        const val INVOKED_ONLY = 2
    }
}