package com.instabug.library.model.session;

import androidx.annotation.IntDef;
import androidx.annotation.Keep;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

import static com.instabug.library.model.session.SyncStatus.OFFLINE;
import static com.instabug.library.model.session.SyncStatus.READY_FOR_SYNC;
import static com.instabug.library.model.session.SyncStatus.SYNCED_WITH_REMOTE;

@Keep
@Retention(RetentionPolicy.SOURCE)
@IntDef({OFFLINE, READY_FOR_SYNC, SYNCED_WITH_REMOTE})
public @interface SyncStatus {

    int OFFLINE = 0;
    int READY_FOR_SYNC = 1;
    int SYNCED_WITH_REMOTE = 2;
}
