package com.instabug.library.model.common;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

/**
 * Instances of this class represent a span of activity separated by UI visibility changes.
 * It starts when the app becomes visible and ends when the app is sent to the background or terminated.
 * <p>
 * This helps us to account for the multitasking nature of mobile device usage and present a more
 * accurate picture of how often and how long a user may be on an app.
 */
public interface Session {

    /**
     * @return this session's unique identifier.
     */
    @NonNull
    String getId();

    /**
     * @return the OS versions that this session is running on
     */
    @NonNull
    String getOs();

    /**
     * @return the current user unique ID
     */
    @NonNull
    String getUuid();

    /**
     * @return the current app version that this session is running on
     */
    @Nullable
    String getAppVersion();

    /**
     * @return the session start timestamp represented in micro seconds
     */
    long getStartTimestampMicros();

    /**
     * @return the session start nano time
     * @see System#nanoTime()
     */
    long getStartNanoTime();

    /**
     * @return session version
     * @see SessionVersion
     */

    @SessionVersion
    String getVersion();
}
