package com.instabug.library.model

import android.graphics.Typeface
import androidx.annotation.ColorInt
import androidx.annotation.IntDef

class IBGTheme private constructor(
    builder: IBGTheme.Builder
) {
    val primaryTextFont: Typeface? = builder.primaryTextFont
    val secondaryTextFont: Typeface? = builder.secondaryTextFont
    val ctaTextFont: Typeface? = builder.ctaTextFont

    @TextStyle
    val ctaTextStyle: Int = builder.ctaTextStyle

    @TextStyle
    val primaryTextStyle: Int = builder.primaryTextStyle

    @ColorInt
    val primaryTextColor: Int = builder.primaryTextColor

    @TextStyle
    val secondaryTextStyle: Int = builder.secondaryTextStyle

    @ColorInt
    val secondaryTextColor: Int = builder.secondaryTextColor

    @ColorInt
    val titleTextColor: Int = builder.titleTextColor

    @ColorInt
    val backgroundColor: Int = builder.backgroundColor

    @ColorInt
    val primaryColor: Int = builder.primaryColor

    class Builder {
        internal var primaryTextFont: Typeface? = null
            private set
        internal var secondaryTextFont: Typeface? = null
            private set
        internal var ctaTextFont: Typeface? = null
            private set

        @TextStyle
        internal var ctaTextStyle: Int = Typeface.NORMAL
            private set

        @TextStyle
        internal var primaryTextStyle: Int = Typeface.NORMAL
            private set
        @ColorInt
        internal var primaryTextColor: Int = 0
            private set
        @TextStyle
        internal var secondaryTextStyle: Int = Typeface.NORMAL
            private set
        @ColorInt
        internal var secondaryTextColor: Int = 0
            private set
        @ColorInt
        internal var titleTextColor: Int = 0
            private set
        @ColorInt
        internal var backgroundColor: Int = 0
            private set
        @ColorInt
        internal var primaryColor: Int = 0
            private set

        fun setPrimaryTextFont(typeface: Typeface): Builder {
            this.primaryTextFont = typeface
            return this
        }

        fun setSecondaryTextFont(typeface: Typeface): Builder {
            this.secondaryTextFont = typeface
            return this
        }

        fun setCtaTextFont(typeface: Typeface): Builder {
            this.ctaTextFont = typeface
            return this
        }

        fun setCtaTextStyle(@TextStyle style: Int): Builder {
            this.ctaTextStyle = style
            return this
        }

        fun setPrimaryTextStyle(@TextStyle style: Int): Builder {
            this.primaryTextStyle = style
            return this
        }

        fun setPrimaryTextColor(@ColorInt color: Int): Builder {
            this.primaryTextColor = color
            return this
        }

        fun setSecondaryTextStyle(@TextStyle style: Int): Builder {
            this.secondaryTextStyle = style
            return this
        }

        fun setSecondaryTextColor(@ColorInt color: Int): Builder {
            this.secondaryTextColor = color
            return this
        }

        fun setTitleTextColor(@ColorInt color: Int): Builder {
            this.titleTextColor = color
            return this
        }

        fun setBackgroundColor(@ColorInt color: Int): Builder {
            this.backgroundColor = color
            return this
        }

        fun setPrimaryColor(@ColorInt color: Int): Builder {
            this.primaryColor = color
            return this
        }

        fun build() = IBGTheme(
            this
        )
    }

    @Target(AnnotationTarget.PROPERTY, AnnotationTarget.VALUE_PARAMETER, AnnotationTarget.TYPE)
    @IntDef(Typeface.NORMAL, Typeface.BOLD, Typeface.ITALIC, Typeface.BOLD_ITALIC)
    annotation class TextStyle
}
