package com.instabug.library.migration;

import android.annotation.SuppressLint;
import android.content.Context;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.instabug.library.settings.SettingsManager;
import com.instabug.library.util.InstabugSDKLogger;

import java.io.File;

import io.reactivexport.Observable;
import io.reactivexport.ObservableEmitter;
import io.reactivexport.ObservableOnSubscribe;

/**
 * Created by mesbah on 11/14/16.
 */

public class V2CacheFilesMigration extends AbstractMigration {
    private static final String V2_CACHE_FILES_MIGRATION = "v2_cache_files_migration";
    private static final String ISSUES_FILE_NAME = "/issues.cache";
    private static final String CONVERSATION_FILE_NAME = "/conversations.cache";

    @Nullable
    private Context context;

    V2CacheFilesMigration() {
        super(V2_CACHE_FILES_MIGRATION);
    }

    @Override
    public int getMigrationVersion() {
        return 2;
    }

    @Override
    public void initialize(@NonNull Context context) {
        this.context = context;
    }

    @Override
    public boolean shouldMigrate() {
        if (getMigrationVersion() <= SettingsManager.getInstance().getLastMigrationVersion()
                || context == null) {
            return false;
        }
        File issuesCacheFile = new File(context.getCacheDir() + ISSUES_FILE_NAME);
        File conversationsCacheFile = new File(context.getCacheDir() + CONVERSATION_FILE_NAME);
        return (issuesCacheFile.exists() || conversationsCacheFile.exists());
    }

    @Override
    public Observable<AbstractMigration> migrate() {
        if (context == null) return Observable.empty();
        return Observable.create(new ObservableOnSubscribe<AbstractMigration>() {

            @Override
            @SuppressLint("NULL_DEREFERENCE")
            public void subscribe(ObservableEmitter<AbstractMigration> emitter) {
                if (context != null) {
                    File issuesCacheFile = new File(context.getCacheDir() + ISSUES_FILE_NAME);
                    File conversationsCacheFile = new File(context.getCacheDir() + CONVERSATION_FILE_NAME);


                    if (issuesCacheFile.exists())
                        issuesCacheFile.delete();


                    if (conversationsCacheFile.exists())
                        conversationsCacheFile.delete();


                    emitter.onNext(V2CacheFilesMigration.this);
                    emitter.onComplete();
                }
            }
        });
    }

    @Override
    public void doPreMigration() {

    }

    @Override
    public void doAfterMigration() {

    }
}
