package com.instabug.library.internal.video.customencoding

import android.media.MediaCodecInfo
import android.os.Build
import androidx.annotation.RequiresApi


@RequiresApi(Build.VERSION_CODES.JELLY_BEAN_MR2)
data class VideoEncoderConfig
@JvmOverloads constructor(
    val height: Int,
    val width: Int,
    val bitrate: Int = 8 * 1000 * 1000,
    val iFrameInterval: Int = 5,
    val frameRate: Int = 30,
    val codec: String = "OMX.MTK.VIDEO.ENCODER.AVC",
    val colorFormat: Int = MediaCodecInfo.CodecCapabilities.COLOR_FormatSurface,
)