package com.instabug.library.internal.storage.executor;

import android.annotation.SuppressLint;

import com.instabug.library.internal.storage.operation.DiskOperation;
import com.instabug.library.internal.storage.operation.DiskOperationCallback;

import java.io.IOException;

import androidx.annotation.NonNull;

public class ReadOperationExecutor {

    private final DiskOperation<String, Void> operation;

    public ReadOperationExecutor(@NonNull DiskOperation<String, Void> operation) {
        this.operation = operation;
    }

    @SuppressLint("ERADICATE_PARAMETER_NOT_NULLABLE")
    public String execute() throws IOException {
        return operation.execute(null);
    }

    @SuppressLint("ERADICATE_PARAMETER_NOT_NULLABLE")
    public void executeAsync(DiskOperationCallback<String> callback) {
        operation.executeAsync(null, callback);
    }
}
