package com.instabug.library.internal.storage.cache.dbv2.migration

import android.database.sqlite.SQLiteDatabase
import com.instabug.library.internal.storage.cache.dbv2.IBGEncryptedDbVersions
import com.instabug.library.internal.storage.cache.dbv2.IBGDbContract.*


private const val ALTER_TABLE_QUERY = "ALTER TABLE %s ADD COLUMN %s%s DEFAULT NULL"

class DBMigrationV8(override val db: SQLiteDatabase) : BaseDBMigrationImpl(db) {

    override val previous: BaseDbMigration by lazy { DBMigrationV7(db) }

    override val version: Int
        get() = IBGEncryptedDbVersions.DB_V8

    override fun execute() = runLogic {
        with(db) {
            addUUIDToFatalHangs()
            addUUIDToTerminations()
            execSQL(SessionIncidentEntry.CREATE_TABLE)
        }
    }

    private fun SQLiteDatabase.addUUIDToFatalHangs() =
        ALTER_TABLE_QUERY.format(
            FatalHangEntry.TABLE_NAME,
            FatalHangEntry.COLUMN_UUID,
            TEXT_TYPE
        ).let { query -> execSQL(query) }

    private fun SQLiteDatabase.addUUIDToTerminations() =
        ALTER_TABLE_QUERY.format(
            AppTerminationEntry.TABLE_NAME,
            AppTerminationEntry.COLUMN_UUID,
            TEXT_TYPE
        ).let { query -> execSQL(query) }
}






