package com.instabug.library.internal.storage.cache.dbv2.migration

import android.database.sqlite.SQLiteDatabase
import com.instabug.library.diagnostics.diagnostics_db.NonFatalEntry
import com.instabug.library.diagnostics.diagnostics_db.NonFatalOccurrenceEntry
import com.instabug.library.internal.storage.cache.dbv2.IBGDbContract
import com.instabug.library.internal.storage.cache.dbv2.IBGEncryptedDbVersions.DB_V5

class DBMigrationV5(override val db: SQLiteDatabase) : BaseDBMigrationImpl(db) {
    override val previous: BaseDbMigration? by lazy { DBMigrationV4(db) }
    override val version: Int
        get() = DB_V5

    override fun execute() = runLogic {
        db.execSQL(NonFatalOccurrenceEntry.DELETE_ALL)
        db.execSQL(NonFatalEntry.DROP_TABLE)
        db.execSQL(NonFatalEntry.CREATE_TABLE)
    }
}