package com.instabug.library.internal.storage.cache.dbv2.migration

import android.content.ContentValues
import android.database.sqlite.SQLiteDatabase
import com.instabug.library.internal.storage.cache.dbv2.IBGDbContract
import com.instabug.library.internal.storage.cache.dbv2.IBGDbContract.SessionReplayMetadataEntry
import com.instabug.library.internal.storage.cache.dbv2.IBGEncryptedDbVersions
import com.instabug.library.sessionreplay.SyncStatus

class DBMigrationV18(override val db: SQLiteDatabase) : BaseDBMigrationImpl(db) {

    override val previous: BaseDbMigration? by lazy { DBMigrationV17(db) }
    override val version: Int
        get() = IBGEncryptedDbVersions.DB_V18


    override fun execute() {
        runLogic {
            db.execSQL(
                "ALTER TABLE ${IBGDbContract.SessionEntry.TABLE_NAME} ADD COLUMN " +
                        "${IBGDbContract.SessionEntry.COLUMN_SR_EVALUATED}  ${IBGDbContract.INTEGER_TYPE}  DEFAULT 1"
            )
            db.update(
                SessionReplayMetadataEntry.TABLE_NAME,
                ContentValues().apply { put(SessionReplayMetadataEntry.COLUMN_STATUS, SyncStatus.READY_FOR_SYNC) },
                SessionReplayMetadataEntry.COLUMN_STATUS + " = ?",
                arrayOf(SyncStatus.OFFLINE)
            )
        }
    }
}
