package com.instabug.library.internal.storage.cache.dbv2;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.instabug.library.Feature;
import com.instabug.library.InstabugFeaturesManager;
import com.instabug.library.encryption.EncryptionManager;

import java.util.List;

public class IBGWhereArg {

    private final String value;
    private final boolean transitive;
    private final boolean encryptionEnabled;

    public IBGWhereArg(@NonNull String value, boolean transitive) {
        this.value = value;
        this.transitive = transitive;

        encryptionEnabled = InstabugFeaturesManager.getInstance().getDbEncryptionState() == Feature.State.ENABLED;
    }

    public static String[] argsListToStringArray(@Nullable List<IBGWhereArg> args) {
        if (args != null) {
            String[] stringArgs = new String[args.size()];
            for (int i = 0; i < args.size(); i++) {
                if (args.get(i) != null) {
                    stringArgs[i] = args.get(i).getValue();
                }
            }

            return stringArgs;
        } else {
            return new String[0];
        }
    }

    @Nullable
    public String getValue() {
        if (transitive || !encryptionEnabled) {
            return value;
        } else {
            return EncryptionManager.encrypt(value, EncryptionManager.IV_V2);
        }
    }
}