package com.instabug.library.internal.storage.cache.db.migrations

import android.database.sqlite.SQLiteDatabase
import com.instabug.library.diagnostics.diagnostics_db.BOOLEAN_TYPE
import com.instabug.library.diagnostics.diagnostics_db.INTEGER_TYPE
import com.instabug.library.internal.storage.cache.db.InstabugDbContract.APMComposeSpansEntry
import com.instabug.library.internal.storage.cache.db.InstabugDbContract.DEFAULT
import com.instabug.library.internal.storage.cache.db.InstabugDbContract.NULL

class Migration_52_53 : Migration {

    private val migrationDBStatements = listOf(
        String.format(
            ALTER_TABLE_ADD_COLUMN,
            APMComposeSpansEntry.COLUMN_SHOW_AS_SCREEN,
            BOOLEAN_TYPE,
            "0"
        ),
        String.format(
            ALTER_TABLE_ADD_COLUMN,
            APMComposeSpansEntry.COLUMN_DURATION_MICROS,
            INTEGER_TYPE,
            NULL
        ),
        String.format(
            ALTER_TABLE_ADD_COLUMN,
            APMComposeSpansEntry.COLUMN_START_TIMESTAMP_MICROS,
            INTEGER_TYPE,
            NULL
        )
    )

    override fun migrate(db: SQLiteDatabase?) {
        db?.apply { migrationDBStatements.forEach(::execSQL) }
    }

    companion object {
        private const val ALTER_TABLE_ADD_COLUMN =
            "ALTER TABLE ${APMComposeSpansEntry.TABLE_NAME} ADD COLUMN %s %S $DEFAULT %s"
    }
}
