package com.instabug.library.internal.storage.cache.db.migrations

import android.database.sqlite.SQLiteDatabase
import com.instabug.library.diagnostics.diagnostics_db.TEXT_TYPE
import com.instabug.library.internal.storage.cache.db.InstabugDbContract.APMNetworkLogEntry
import com.instabug.library.internal.storage.cache.db.InstabugDbContract.DanglingAPMNetworkLogEntry

class Migration_41_42 : Migration {
    override fun migrate(db: SQLiteDatabase?) {
        db?.apply {
            addNetworkLatencySpansFieldToDanglingAPMNetworkLogTable()
            addNetworkLatencySpansFieldToAPMNetworkLogTable()
        }
    }

    private fun SQLiteDatabase.addNetworkLatencySpansFieldToDanglingAPMNetworkLogTable() = execSQL(
        "ALTER TABLE ${DanglingAPMNetworkLogEntry.TABLE_NAME} ADD COLUMN ${DanglingAPMNetworkLogEntry.COLUMN_NETWORK_LATENCY_SPANS} $TEXT_TYPE"
    )

    private fun SQLiteDatabase.addNetworkLatencySpansFieldToAPMNetworkLogTable() = execSQL(
        "ALTER TABLE ${APMNetworkLogEntry.TABLE_NAME} ADD COLUMN ${APMNetworkLogEntry.COLUMN_NETWORK_LATENCY_SPANS} $TEXT_TYPE"
    )
}