package com.instabug.library.internal.storage.cache.db.migrations

import android.database.sqlite.SQLiteDatabase
import com.instabug.library.internal.storage.cache.db.InstabugDbContract.BOOLEAN_TYPE
import com.instabug.library.internal.storage.cache.db.InstabugDbContract.NetworkLogEntry.COLUMN_USER_MODIFIED
import com.instabug.library.internal.storage.cache.db.InstabugDbContract.NetworkLogEntry.TABLE_NAME
import com.instabug.library.internal.storage.cache.db.MigrationUtilities.columnExists

class Migration_38_39 : Migration {

    override fun migrate(db: SQLiteDatabase) {
        if (db.columnExists(TABLE_NAME, COLUMN_USER_MODIFIED))
            return

        db.execSQL("ALTER TABLE $TABLE_NAME ADD COLUMN $COLUMN_USER_MODIFIED $BOOLEAN_TYPE DEFAULT 0")
    }
}