package com.instabug.library.internal.storage.cache.db.migrations

import android.database.sqlite.SQLiteDatabase
import com.instabug.library.internal.storage.cache.db.InstabugDbContract.CrashEntry.COLUMN_FINGERPRINT
import com.instabug.library.internal.storage.cache.db.InstabugDbContract.CrashEntry.TABLE_NAME
import com.instabug.library.internal.storage.cache.db.InstabugDbContract.TEXT_TYPE
import com.instabug.library.safetyUse

class Migration_35_36 : Migration {

    override fun migrate(db: SQLiteDatabase) {
        if (db.fingerprintColumnExists) return
        db.execSQL("ALTER TABLE $TABLE_NAME ADD COLUMN $COLUMN_FINGERPRINT$TEXT_TYPE DEFAULT NULL;")
    }

    private val SQLiteDatabase.fingerprintColumnExists: Boolean
        get() = runCatching {
            rawQuery("SELECT * FROM $TABLE_NAME LIMIT 0", arrayOf())
                ?.safetyUse { cursor -> cursor.getColumnIndex(COLUMN_FINGERPRINT) != -1
                } ?: false
        }.getOrDefault(false)
}