package com.instabug.library.internal.storage.cache.db.migrations;

import android.database.sqlite.SQLiteDatabase;

import com.instabug.library.internal.storage.cache.db.InstabugDbContract;
import com.instabug.library.internal.storage.cache.db.contract.apm.ApmEntry;

/**
 * Allows the database to destructively recreate database tables if Migrations that would migrate
 * old database schemas to the latest schema version are not found.
 * <p>
 * Schemas are defined in {@link InstabugDbContract}. Any changes to these schemas will require
 * a migration.
 */
public class DestructiveMigration implements Migration {

    @Override
    public void migrate(SQLiteDatabase db) {
        dropTables(db);
        createTables(db);
    }

    public void dropTables(SQLiteDatabase db) {
        db.execSQL(InstabugDbContract.InstabugLogEntry.DROP_QUERY_INSTABUG_LOG);
        db.execSQL(InstabugDbContract.NetworkLogEntry.SQL_DELETE_ENTRIES);
        db.execSQL(InstabugDbContract.AnnouncementAssetsEntry.DROP_TABLE);
        db.execSQL(InstabugDbContract.FeatureRequestEntry.DROP_TABLE);
        db.execSQL(InstabugDbContract.UserAttributesEntry.DROP_TABLE);
        db.execSQL(InstabugDbContract.AnnouncementEntry.DROP_TABLE);
        db.execSQL(InstabugDbContract.UserInteractions.DROP_TABLE);
        db.execSQL(InstabugDbContract.AttachmentEntry.DROP_TABLE);
        db.execSQL(InstabugDbContract.UserEventEntry.DROP_TABLE);
        db.execSQL(InstabugDbContract.SessionEntry.DROP_TABLE);
        db.execSQL(InstabugDbContract.SurveyEntry.DROP_TABLE);
        db.execSQL(InstabugDbContract.UserEntity.DROP_TABLE);
        db.execSQL(InstabugDbContract.CrashEntry.DROP_TABLE);
        db.execSQL(InstabugDbContract.AnrEntry.DROP_TABLE);
        db.execSQL(InstabugDbContract.AppLaunchEntry.DROP_TABLE_QUERY);
        db.execSQL(InstabugDbContract.AppLaunchAttributesEntry.DROP_TABLE_QUERY);
        db.execSQL(InstabugDbContract.APMNetworkLogEntry.DROP_TABLE_QUERY);
        db.execSQL(InstabugDbContract.NetworkTracesAttributesEntry.DROP_TABLE_QUERY);
        db.execSQL(InstabugDbContract.DanglingNetworkTracesAttributesEntry.DROP_TABLE_QUERY);
        db.execSQL(InstabugDbContract.APMSessionEntry.DROP_TABLE);
        db.execSQL(InstabugDbContract.APMSessionMetaDataEntry.DROP_TABLE_QUERY);
        db.execSQL(InstabugDbContract.APMUiLoadingMetricEntry.DROP_TABLE_QUERY);
        db.execSQL(InstabugDbContract.APMUiLoadingStageEntry.DROP_TABLE_QUERY);
        db.execSQL(InstabugDbContract.APMUiTraceEntry.DROP_TABLE_QUERY);
        db.execSQL(InstabugDbContract.DanglingAPMNetworkLogEntry.DROP_TABLE_QUERY);
        db.execSQL(InstabugDbContract.DanglingExecutionTracesEntry.DROP_TABLE_QUERY);
        db.execSQL(InstabugDbContract.DanglingExecutionTracesAttributesEntry.DROP_TABLE_QUERY);
        db.execSQL(InstabugDbContract.NDKCrashEntry.DROP_TABLE);
        db.execSQL(InstabugDbContract.APMFragmentEntry.DROP_TABLE_QUERY);
        db.execSQL(InstabugDbContract.APMFragmentEventsEntry.DROP_TABLE_QUERY);
        db.execSQL(InstabugDbContract.APMComposeSpansEntry.DROP_TABLE_QUERY);
        String[] apmQueries = ApmEntry.getTableDroppingQueries();
        for (String query: apmQueries) {
            db.execSQL(query);
        }
    }

    public void createTables(SQLiteDatabase db) {
        db.execSQL(InstabugDbContract.CrashEntry.CREATE_TABLE);
        db.execSQL(InstabugDbContract.AnrEntry.CREATE_TABLE);
        db.execSQL(InstabugDbContract.UserEntity.CREATE_TABLE);
        db.execSQL(InstabugDbContract.SurveyEntry.CREATE_TABLE);
        db.execSQL(InstabugDbContract.SessionEntry.CREATE_TABLE);
        db.execSQL(InstabugDbContract.UserEventEntry.CREATE_TABLE);
        db.execSQL(InstabugDbContract.AttachmentEntry.CREATE_TABLE);
        db.execSQL(InstabugDbContract.UserInteractions.CREATE_TABLE);
        db.execSQL(InstabugDbContract.AnnouncementEntry.CREATE_TABLE);
        db.execSQL(InstabugDbContract.UserAttributesEntry.CREATE_TABLE);
        db.execSQL(InstabugDbContract.FeatureRequestEntry.CREATE_TABLE);
        db.execSQL(InstabugDbContract.AnnouncementAssetsEntry.CREATE_TABLE);
        db.execSQL(InstabugDbContract.AppLaunchEntry.CREATE_TABLE_QUERY);
        db.execSQL(InstabugDbContract.AppLaunchAttributesEntry.CREATE_TABLE_QUERY);
        db.execSQL(InstabugDbContract.APMNetworkLogEntry.CREATE_TABLE_QUERY);
        db.execSQL(InstabugDbContract.NetworkTracesAttributesEntry.CREATE_TABLE_QUERY);
        db.execSQL(InstabugDbContract.DanglingNetworkTracesAttributesEntry.CREATE_TABLE_QUERY);
        db.execSQL(InstabugDbContract.APMUiTraceEntry.CREATE_TABLE_QUERY);
        db.execSQL(InstabugDbContract.APMUiLoadingMetricEntry.CREATE_TABLE_QUERY);
        db.execSQL(InstabugDbContract.APMUiLoadingStageEntry.CREATE_TABLE_QUERY);
        db.execSQL(InstabugDbContract.APMSessionEntry.CREATE_TABLE);
        db.execSQL(InstabugDbContract.APMSessionMetaDataEntry.CREATE_TABLE_QUERY);
        db.execSQL(InstabugDbContract.DanglingAPMNetworkLogEntry.CREATE_TABLE_QUERY);
        db.execSQL(InstabugDbContract.DanglingExecutionTracesEntry.CREATE_TABLE_QUERY);
        db.execSQL(InstabugDbContract.DanglingExecutionTracesAttributesEntry.CREATE_TABLE_QUERY);
        db.execSQL(InstabugDbContract.NDKCrashEntry.CREATE_TABLE);
        db.execSQL(InstabugDbContract.APMFragmentEntry.CREATE_TABLE_QUERY);
        db.execSQL(InstabugDbContract.APMFragmentEventsEntry.CREATE_TABLE_QUERY);
        db.execSQL(InstabugDbContract.APMComposeSpansEntry.CREATE_TABLE_QUERY);
        db.execSQL(InstabugDbContract.APMWebViewTraceEntry.CREATE_TABLE_QUERY);
        String[] apmQueries = ApmEntry.getTableCreationQueries();
        for (String query: apmQueries) {
            db.execSQL(query);
        }
    }
}
