package com.instabug.library.internal.servicelocator;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;

/**
 * ServiceRegistry is the data structure for caching objects instances for the {@link ServiceLocator}.
 * Some ServiceRegistries may allow duplicate elements and others do not.
 */
@RestrictTo(RestrictTo.Scope.LIBRARY_GROUP)
public interface ServiceRegistry {

    /**
     * Returns the instance to which the specified service type is mapped to,
     * or {@code null} if no mapping for the serviceType was found.
     *
     * @param serviceType the class type of the requested service
     * @return the service instance if present or {@code null} otherwise
     */
    @Nullable
    @RestrictTo(RestrictTo.Scope.LIBRARY_GROUP)
    <T> T get(@NonNull Class<T> serviceType);

    /**
     * Inserts the specified service to the current registry. Some ServiceRegistries may
     * allow duplicate elements and others do not.
     *
     * @param service the service to be inserted
     */
    @RestrictTo(RestrictTo.Scope.LIBRARY_GROUP)
    <T> void add(@NonNull T service);

    /**
     * Disposes all held resources.
     */
    @RestrictTo(RestrictTo.Scope.LIBRARY_GROUP)
    void clear();
}
