package com.instabug.library.internal.servicelocator;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

class ServiceLocatorImpl extends ServiceLocator {

    private final InitialContext initialContext;
    private final ServiceRegistry registry;

    ServiceLocatorImpl(InitialContext initialContext, ServiceRegistry registry) {
        this.initialContext = initialContext;
        this.registry = registry;
    }

    @Nullable
    @Override
    public <T> T getService(@NonNull Class<T> serviceType) {
        T service = registry.get(serviceType);
        if (service == null) {
            service = initialContext.lookup(serviceType);
            if (service != null) registry.add(service);
        }
        return service;
    }

    @Override
    public void releaseHeldResources() {
        registry.clear();
    }
}
