package com.instabug.library.internal.orchestrator;

import com.instabug.library.internal.storage.cache.CacheManager;
import com.instabug.library.internal.storage.cache.user.UserCacheManager;

public class InvalidateCacheForIdentifyingUserAction implements Action {

    private final String uuid;

    public InvalidateCacheForIdentifyingUserAction(String uuid) {
        this.uuid = uuid;
    }

    @Override
    public void run() throws Exception {
        CacheManager.getInstance().invalidateAllCachesForIdentifyingUsers();
        UserCacheManager.updateLastSeen(uuid, 0);
    }
}
