package com.instabug.library.internal.device;

import com.instabug.library.Constants;
import com.instabug.library.util.InstabugSDKLogger;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;



public class InstabugRootChecker {

    private static final String SUPER_USER_PATH = "/system/app/Superuser.apk";

    public static boolean isDeviceRooted() {
        return checkRootMethod1() || checkRootMethod2() || checkRootMethod3();
    }

    public static boolean checkRootMethod1() {
        String buildTags = android.os.Build.TAGS;
        return buildTags != null && buildTags.contains("test-keys");
    }

    public static boolean checkRootMethod2() {
        try {
            File file = new File(SUPER_USER_PATH);
            return file.exists();
        } catch (Exception e) {
            return false;
        }
    }

    public static boolean checkRootMethod3() {
        String line = null;
        ArrayList<String> fullResponse = new ArrayList<String>();
        Process localProcess = null;
        try {
            localProcess = Runtime.getRuntime().exec(new String[]{"/system/xbin/which", "su"});
        } catch (Exception e) {
            return false;
        }
        BufferedReader in = new BufferedReader(new InputStreamReader(
                localProcess.getInputStream(), Charset.forName("UTF-8")));
        try {
            while ((line = in.readLine()) != null) {
                InstabugSDKLogger.v(Constants.LOG_TAG, "SHELL --> Line received: " + line);
                fullResponse.add(line);
            }
        } catch (Exception e) {
        } finally {
            localProcess.destroy();
            try {
                in.close();
            } catch (IOException e) {
            }

        }
        InstabugSDKLogger.v(Constants.LOG_TAG, "SHELL --> Full response was: " +
                fullResponse);
        return fullResponse.size() != 0;
    }
}
