package com.instabug.library.internal.dataretention;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import androidx.annotation.NonNull;

/**
 * This policy sets the required retention periods for specified categories of user's data and sets
 * out the minimum standards to be applied when destroying certain information.
 * This policy can be applied to all user's information (i.e. UserEvents, UserAttributes, etc...)
 *
 * @deprecated see {@link com.instabug.library.internal.dataretention.core.DisposalPolicy}
 */
@Deprecated
public abstract class DisposalPolicy {

    public static DisposalPolicy create(final String tableName,
                                        final String idColumn,
                                        final String lastLoginColumn,
                                        final RetentionContract retentionContract) {
        return new DisposalPolicy() {
            @NonNull
            @Override
            public Scope scope() {
                return new Scope.Factory().create(tableName, idColumn, lastLoginColumn);
            }

            @Override
            public RetentionContract retentionContract() {
                return retentionContract;
            }
        };
    }

    public static DisposalPolicy create(final String tableName,
                                        final String idColumn,
                                        final String lastLoginColumn,
                                        final RetentionContract retentionContract,
                                        final Rule... rules) {
        return new DisposalPolicy() {
            @NonNull
            @Override
            public Scope scope() {
                return new Scope.Factory().create(tableName, idColumn, lastLoginColumn);
            }

            @NonNull
            @Override
            public List<Rule> exceptionRules() {
                return Arrays.asList(rules);
            }

            @Override
            public RetentionContract retentionContract() {
                return retentionContract;
            }
        };
    }

    /**
     * @return The scope of data in which the DisposalPolicy should be applied to
     */
    @NonNull
    public abstract Scope scope();

    /**
     * Represents the exception/corner cases in which the data may need to be retained for a longer
     * period of time even though it has been expired. Unless the rules are not empty, the required
     * retention period for such data will be deemed to be the {@link RetentionContract#maxRetentionPeriodMillis()}
     *
     * @return A list of exception rules (if any). Empty list by default
     */
    @NonNull
    public List<Rule> exceptionRules() {
        return Collections.emptyList();
    }

    /**
     * Specifies how long data are to be retained.
     */
    public abstract RetentionContract retentionContract();
}
