package com.instabug.library.diagnostics.sdkEvents.di

import android.content.Context
import android.content.SharedPreferences
import com.instabug.library.Instabug
import com.instabug.library.diagnostics.configuration.ConfigurationChangedHandler
import com.instabug.library.diagnostics.diagnostics_db.DiagnosticsDbManager
import com.instabug.library.diagnostics.mappers.RequestParameterResolver
import com.instabug.library.diagnostics.sdkEvents.*
import com.instabug.library.diagnostics.sdkEvents.cache.SDKEventsCachingManager
import com.instabug.library.diagnostics.sdkEvents.cache.SDKEventsCachingManagerImpl
import com.instabug.library.diagnostics.sdkEvents.cache.SDKEventsDbHelper
import com.instabug.library.diagnostics.sdkEvents.cache.SDKEventsDbHelperImpl
import com.instabug.library.diagnostics.sdkEvents.configurations.SDKEventConfigs
import com.instabug.library.diagnostics.sdkEvents.configurations.SDKEventConfigsImpl
import com.instabug.library.diagnostics.sdkEvents.mappers.SDKEventDbMapper
import com.instabug.library.diagnostics.sdkEvents.mappers.SDKEventsRequestParameterResolver
import com.instabug.library.internal.sharedpreferences.corePreferences
import com.instabug.library.settings.SettingsManager
import com.instabug.library.util.threading.PoolProvider
import java.util.concurrent.ThreadPoolExecutor

object SDKEventsServiceLocator {
    const val SDK_EVENTS_LOCK = "sdk_events_lock"

    val preferences: SharedPreferences?
        @Synchronized get() = corePreferences

    val sdkEventConfigs: SDKEventConfigs
        @Synchronized get() = SDKEventConfigsImpl(SettingsManager.getInstance(), preferences)

    private val sdkEventsDbHelper: SDKEventsDbHelper
        @Synchronized get() = SDKEventsDbHelperImpl(
            SDKEventDbMapper(),
            DiagnosticsDbManager.getInstance()
        )

    val sdkEventsCachingManager: SDKEventsCachingManager
        @Synchronized get() = SDKEventsCachingManagerImpl(
            sdkEventsDbHelper,
            SDKEventsValidator(sdkEventConfigs)
        )

    val sdkEventsConfigurationChangedHandler: ConfigurationChangedHandler
        @Synchronized get() = SDKEventsConfigurationChangedHandler()

    val sdkEventsExecutor: ThreadPoolExecutor
        @Synchronized get() = PoolProvider.getInstance().ioExecutor

    @JvmStatic
    val sdkEventsHandler: SDKEventsHandler
        @Synchronized get() = SDKEventsHandler()

    val sdkEventRequestParameterResolver: RequestParameterResolver<*>
        @Synchronized get() = SDKEventsRequestParameterResolver()

    val sdkEventsManager: SDKEventsManager
        @Synchronized get() = SDKEventsManagerImpl()
}