package com.instabug.library.diagnostics.nonfatals;

import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;

import com.instabug.library.diagnostics.nonfatals.model.NonFatal;

import java.util.Set;

public class IgnoreListHelper {

    public static boolean shouldBeIgnored(NonFatal nonFatalToReport, @Nullable Set<NonFatal> ignoredList) {
        if (nonFatalToReport != null && nonFatalToReport.getExceptionType() != null) {
            if (isNetworkException(nonFatalToReport.getExceptionType())) {
                return true;
            }

            if (ignoredList != null) {
                for (NonFatal nonFatal : ignoredList) {
                    if (compareNonFatalWithThrowable(nonFatal, nonFatalToReport)) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private static boolean compareNonFatalWithThrowable(NonFatal ignoredNonFatal, NonFatal nonFatalToReport) {

        String fileName = ignoredNonFatal.getFileName();
        String className = ignoredNonFatal.getDeclaringClass();
        String methodName = ignoredNonFatal.getMethodName();
        String type = ignoredNonFatal.getExceptionType();

        // If ignoredNonFatal has type only then we should ignore type only
        boolean typeMatch = type != null && type.equals(nonFatalToReport.getExceptionType());
        boolean classNameMatch = className == null || className.equals(nonFatalToReport.getDeclaringClass());
        boolean fileMatch = fileName == null || fileName.equals(nonFatalToReport.getFileName());
        boolean methodMatch = methodName == null || methodName.equals(nonFatalToReport.getMethodName());

        return typeMatch && classNameMatch && fileMatch && methodMatch;
    }

    @VisibleForTesting
    static boolean isNetworkException(String exceptionType) {
        return exceptionType.startsWith("java.net") || exceptionType.startsWith("javax.net") || exceptionType.startsWith("com.instabug.library.networkv2");
    }
}
