package com.instabug.library.diagnostics.diagnostics_db

import android.provider.BaseColumns
import com.instabug.library.internal.storage.cache.dbv2.IBGDbContract

const val TEXT_TYPE = " TEXT"
const val INTEGER_TYPE = " INTEGER"
const val BOOLEAN_TYPE = " BOOLEAN"
const val COMMA_SEP = ","
const val DEFAULT = " DEFAULT "
private const val CONSTRAINT = " CONSTRAINT "
private const val FOREIGN_KEY = " FOREIGN KEY "
const val BLOB_TYPE = " BLOB"
const val UNIQUE = " UNIQUE "

private const val CREATE_TABLE_IF_NOT_EXISTS = "CREATE TABLE IF NOT EXISTS "
private const val PRIMARY_KEY_AUTOINCREMENT = " PRIMARY KEY AUTOINCREMENT"

object SDKEventsEntry : BaseColumns {
    const val TABLE_NAME = "sdk_events"
    const val COLUMN_KEY = "key"
    const val COLUMN_COUNT = "count"
    const val CREATE_TABLE =
        CREATE_TABLE_IF_NOT_EXISTS + TABLE_NAME +
                " ( " + COLUMN_KEY + IBGDbContract.TEXT_TYPE + " PRIMARY KEY " + IBGDbContract.COMMA_SEP +
                " " + COLUMN_COUNT + IBGDbContract.INTEGER_TYPE + " ) "
    const val DROP_TABLE_QUERY = "DROP TABLE IF EXISTS $TABLE_NAME"
    const val INSERT_STATEMENT =
        "INSERT OR REPLACE INTO $TABLE_NAME ($COLUMN_KEY,$COLUMN_COUNT) " +
                "VALUES( \"%1s\", COALESCE((SELECT $COLUMN_COUNT FROM $TABLE_NAME WHERE $COLUMN_KEY=\"%1s\"),0)+%2s)"
    const val UPDATE_STATEMENT =
        "UPDATE $TABLE_NAME SET $COLUMN_COUNT= " +
                "CASE WHEN $COLUMN_COUNT-%1s>0 THEN ($COLUMN_COUNT-%2s) ELSE 0 END " +
                "WHERE $COLUMN_KEY=\"%3s\""

    object ColumnsTransitiveState {
        const val KEY_TRANSITIVE_STATE = true
        const val COUNT_TRANSITIVE_STATE = true
    }
}


object CustomTracesEntry {
    const val TABLE_NAME = "diagnostics_custom_traces"
    const val COLUMN_ID = "trace_id"
    const val COLUMN_NAME = "name"
    const val COLUMN_START_TIME = "start_time"
    const val COLUMN_DURATION = "duration"
    const val COLUMN_START_BG = "started_on_bg"
    const val COLUMN_END_BG = "ended_on_bg"
    const val DURATION_DEFAULT_VALUE = -1
    const val CREATE_TABLE =
        CREATE_TABLE_IF_NOT_EXISTS + TABLE_NAME +
                " ( " + COLUMN_ID + INTEGER_TYPE + PRIMARY_KEY_AUTOINCREMENT + COMMA_SEP +
                COLUMN_NAME + TEXT_TYPE + COMMA_SEP +
                COLUMN_START_TIME + INTEGER_TYPE + COMMA_SEP +
                COLUMN_START_BG + INTEGER_TYPE + COMMA_SEP +
                COLUMN_END_BG + INTEGER_TYPE + COMMA_SEP +
                COLUMN_DURATION + INTEGER_TYPE + " default " + DURATION_DEFAULT_VALUE + " )"
    const val DROP_TABLE_QUERY = "DROP TABLE IF EXISTS " + TABLE_NAME
    private const val SELECT_BY_LIMIT_QUERY =
        "SELECT rowid FROM $TABLE_NAME ORDER BY rowid DESC LIMIT ? OFFSET ?"

    const val TRIM_TO_LIMIT_WHERE_CLAUSE = "rowid IN ($SELECT_BY_LIMIT_QUERY)"
}


object CustomTracesAttributesEntry {
    const val TABLE_NAME = "custom_traces_attributes"
    const val COLUMN_ID = "attribute_id"
    const val COLUMN_TRACE_ID = "trace_id"
    const val COLUMN_KEY = "attribute_key"
    const val COLUMN_VALUE = "attribute_value"
    const val CREATE_TABLE =
        CREATE_TABLE_IF_NOT_EXISTS + TABLE_NAME +
                " ( " + COLUMN_ID + INTEGER_TYPE +
                PRIMARY_KEY_AUTOINCREMENT + COMMA_SEP +
                COLUMN_TRACE_ID + INTEGER_TYPE + COMMA_SEP +
                COLUMN_KEY + TEXT_TYPE + COMMA_SEP +
                COLUMN_VALUE + TEXT_TYPE + COMMA_SEP +
                "CONSTRAINT " + COLUMN_TRACE_ID + " " + "FOREIGN KEY (" + COLUMN_TRACE_ID + ") REFERENCES " + CustomTracesEntry.TABLE_NAME + "(" + CustomTracesEntry.COLUMN_ID + ") " +
                "ON DELETE CASCADE" + " )"
    const val DROP_TABLE_QUERY = "DROP TABLE IF EXISTS " + TABLE_NAME
}

object NonFatalEntry : BaseColumns {
    const val TABLE_NAME = "non_fatal"
    const val COLUMN_ID = "id"
    const val COLUMN_EXCEPTION_TYPE = "exception_type"
    const val COLUMN_STACKTRACE_DECLARING_CLASS = "declaring_class"
    const val COLUMN_STACKTRACE_FILE_NAME = "file_name"
    const val COLUMN_STACKTRACE_METHOD_NAME = "method_name"
    const val COLUMN_STACKTRACE_LINE_NUMBER = "line_number"
    const val COLUMN_MESSAGE = "message"
    const val COLUMN_STACKTRACE = "stackTrace"
    const val COLUMN_PRIORITY = "priority"

    // CREATE NonFatals table
    const val CREATE_TABLE =
        (CREATE_TABLE_IF_NOT_EXISTS + TABLE_NAME +
                " ( " + COLUMN_ID + INTEGER_TYPE + PRIMARY_KEY_AUTOINCREMENT + COMMA_SEP +
                COLUMN_EXCEPTION_TYPE + TEXT_TYPE + COMMA_SEP +
                COLUMN_STACKTRACE_DECLARING_CLASS + TEXT_TYPE + COMMA_SEP +
                COLUMN_STACKTRACE_FILE_NAME + TEXT_TYPE + COMMA_SEP +
                COLUMN_STACKTRACE_METHOD_NAME + TEXT_TYPE + COMMA_SEP +
                COLUMN_MESSAGE + TEXT_TYPE + COMMA_SEP +
                COLUMN_STACKTRACE + TEXT_TYPE + COMMA_SEP +
                COLUMN_STACKTRACE_LINE_NUMBER + INTEGER_TYPE + COMMA_SEP +
                COLUMN_PRIORITY + INTEGER_TYPE + " DEFAULT 0)")

    // DROP NonFatals table
    const val DROP_TABLE = "DROP TABLE IF EXISTS $TABLE_NAME"

    // Clear table's records
    const val DELETE_ALL = "DELETE FROM $TABLE_NAME"
}

object NonFatalOccurrenceEntry : BaseColumns {
    const val TABLE_NAME = "non_fatal_occurrence"
    const val COLUMN_ID = "id"
    const val COLUMN_REPORTED_AT = "reported_at"
    const val COLUMN_STATE_FILE = "state_file"
    const val COLUMN_NON_FATAL_ID = "non_fatal_id"

    // CREATE NonFatal Occurrences table
    const val CREATE_TABLE =
        CREATE_TABLE_IF_NOT_EXISTS + TABLE_NAME +
                " ( " + COLUMN_ID + INTEGER_TYPE +
                PRIMARY_KEY_AUTOINCREMENT + COMMA_SEP +
                COLUMN_REPORTED_AT + INTEGER_TYPE + COMMA_SEP +
                COLUMN_STATE_FILE + TEXT_TYPE + COMMA_SEP +
                COLUMN_NON_FATAL_ID + INTEGER_TYPE + COMMA_SEP +
                CONSTRAINT + COLUMN_NON_FATAL_ID + COMMA_SEP +
                FOREIGN_KEY + "(" + COLUMN_NON_FATAL_ID + ") REFERENCES " + NonFatalEntry.TABLE_NAME + "(" + NonFatalEntry.COLUMN_ID + ") " +
                "ON DELETE CASCADE" + " )"

    // DROP NonFatal Occurrences table
    const val DROP_TABLE = "DROP TABLE IF EXISTS $TABLE_NAME"

    // Clear table's records
    const val DELETE_ALL = "DELETE FROM $TABLE_NAME"
    private const val SELECT_BY_LIMIT: String =
        "SELECT rowid FROM $TABLE_NAME ORDER BY rowid DESC LIMIT ? OFFSET ?"

    const val TRIM_BY_LIMIT_WHERE_CLAUSE: String = "rowid IN ($SELECT_BY_LIMIT)"
}