package com.instabug.library.diagnostics.customtraces.utils

import androidx.annotation.VisibleForTesting
import com.instabug.library.diagnostics.customtraces.model.IBGCustomTrace
import com.instabug.library.diagnostics.customtraces.network.CustomTracesMappingKeys
import org.json.JSONArray
import org.json.JSONObject

fun List<IBGCustomTrace>.toTracesJsonArray(): JSONArray {
    return JSONArray().apply {
        forEach { trace ->
            put(trace.toJson())
        }
    }
}

fun IBGCustomTrace.toJson(): JSONObject =
    JSONObject().apply {
        put(CustomTracesMappingKeys.NAME, name)
        put(CustomTracesMappingKeys.START_TIME, startTime)
        put(CustomTracesMappingKeys.DURATION, duration)
        put(CustomTracesMappingKeys.BACKGROUND, startedInBG && endedInBG)
        attributes.toJsonObject()?.let {
            put(CustomTracesMappingKeys.ATTRIBUTES, it)
        }
    }

fun HashMap<String, String>.toJsonObject(): JSONObject? =
    takeIf { isNotEmpty() }
        ?.let {
            JSONObject().apply {
                for (key in it.keys) {
                    put(key, it[key])
                }
            }
        }

fun JSONObject.toTracesList(): List<IBGCustomTrace>? =
    optJSONArray(CustomTracesMappingKeys.TRACES_LIST)?.let {
        val list = mutableListOf<IBGCustomTrace>()
        for (i in 0 until it.length()) {
            list.add(it.getJSONObject(i).toCustomTrace())
        }
        list
    }


fun JSONObject.toCustomTrace(): IBGCustomTrace =
    IBGCustomTrace(
        name = optString(CustomTracesMappingKeys.NAME, ""),
        startTime = optLong(CustomTracesMappingKeys.START_TIME, 0),
        duration = optLong(CustomTracesMappingKeys.DURATION, -1L)
    )


