package com.instabug.library.diagnostics.customtraces.network

import com.instabug.library.diagnostics.customtraces.model.IBGCustomTrace
import com.instabug.library.diagnostics.customtraces.utils.toTracesJsonArray
import com.instabug.library.internal.device.InstabugDeviceProperties
import org.json.JSONObject

class CustomTracesMapperImpl : CustomTracesMapper {


    override fun toCustomTracesObject(traces: List<IBGCustomTrace>): JSONObject {
        return JSONObject().apply {
            put(CustomTracesMappingKeys.DEVICE, InstabugDeviceProperties.getDeviceType())
            put(CustomTracesMappingKeys.OS, InstabugDeviceProperties.getCurrentOSLevel().toString())
            put(CustomTracesMappingKeys.TRACES_LIST, traces.toTracesJsonArray())
        }
    }
}