package com.instabug.library.diagnostics;

import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;

import com.instabug.library.diagnostics.customtraces.di.CustomTracesServiceLocator;
import com.instabug.library.diagnostics.customtraces.model.IBGCustomTrace;
import com.instabug.library.diagnostics.nonfatals.NonFatals;
import com.instabug.library.diagnostics.nonfatals.model.NonFatal;
import com.instabug.library.diagnostics.sdkEvents.di.SDKEventsServiceLocator;

import java.util.concurrent.Future;

public class IBGDiagnostics {
    // Non Fatals
    public static void reportNonFatal(Throwable throwable, String message) {
        NonFatals.reportNonFatal(throwable, message, NonFatal.Priority.NORMAL);
    }

    public static void reportNonFatal(Throwable throwable, String message, @NonFatal.Priority int priority) {
        NonFatals.reportNonFatal(throwable, message, priority);
    }

    public static Future<Boolean> reportNonFatalWithPromise(Throwable throwable, String message){
        return reportNonFatalWithPromise(throwable, message, NonFatal.Priority.NORMAL);
    }

    public static Future<Boolean> reportNonFatalWithPromise(Throwable throwable, String message, @NonFatal.Priority int priority){
       return NonFatals.reportNonFatalWithPromise(throwable, message, priority);
    }

    public static void reportNonFatalAndLog(Throwable throwable, String message, String logTag) {
        NonFatals.reportNonFatalAndLog(throwable, message, NonFatal.Priority.NORMAL, logTag);
    }

    public static void reportNonFatalAndLog(
            Throwable throwable,
            String message,
            String logTag,
            @NonFatal.Priority int priority
    ) {
        NonFatals.reportNonFatalAndLog(throwable, message, priority, logTag);
    }

    // SDK events
    public static void logEvent(String key, int count) {
        SDKEventsServiceLocator.getSdkEventsHandler().logEvent(key, count, Thread.currentThread().getStackTrace());
    }

    public static void logEvent(String key) {
        SDKEventsServiceLocator.getSdkEventsHandler().logEvent(key, 1, Thread.currentThread().getStackTrace());
    }

    public static void logEventImmediately(String key, int count) {
        SDKEventsServiceLocator.getSdkEventsHandler().logEventImmediately(key, count, Thread.currentThread().getStackTrace());
    }

    public static void logEventImmediately(String key) {
        SDKEventsServiceLocator.getSdkEventsHandler().logEventImmediately(key, 1, Thread.currentThread().getStackTrace());
    }


    @WorkerThread
    @Nullable
    public static IBGCustomTrace startTrace(String traceName) {
        long startTime = System.currentTimeMillis() * 1000;
        return CustomTracesServiceLocator.getCustomTracesManager().startTrace(traceName, startTime);
    }

    @WorkerThread
    @Nullable
    public static IBGCustomTrace startTrace(String traceName, long startTime) {
        return CustomTracesServiceLocator.getCustomTracesManager().startTrace(traceName, startTime);
    }

    @WorkerThread
    public static void logTrace(String traceName, long startTime, long endTime) {
        CustomTracesServiceLocator.getCustomTracesManager().logTrace(traceName, startTime, endTime);
    }
}