package com.instabug.library.core.plugin;

import android.net.Uri;

import com.instabug.library.Constants;
import com.instabug.library.invocation.InvocationMode;
import com.instabug.library.util.InstabugSDKLogger;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;

import androidx.annotation.DrawableRes;
import androidx.annotation.IntDef;
import androidx.annotation.Nullable;

public class PluginPromptOption implements Serializable {

    public static final int NO_ORDER = -1;
    private int order;
    @Nullable
    private String title;
    @Nullable
    private String description;
    @DrawableRes
    private int icon;
    private int notificationCount;
    @InvocationMode
    private int invocationMode;
    @Nullable
    private OnInvocationListener onInvocationListener;
    @PromptOptionIdentifier
    private int promptOptionIdentifier;
    @Nullable
    private PluginPromptOption parent;
    @Nullable
    private ArrayList<PluginPromptOption> subOptions;

    /**
     * This flag to check whether it's going to use the initial screenshot or not, if it's not gonna
     * use it, then the initial screenshot will be deleted
     */
    private boolean isInitialScreenshotRequired;

    public PluginPromptOption() {
    }

    public int getOrder() {
        return order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    @Nullable
    public String getTitle() {
        return title;
    }

    @Nullable
    public String getDescription() {
        return description;
    }

    public void setTitle(@Nullable String title) {
        this.title = title;
    }

    public void setDescription(@Nullable String description) {
        this.description = description;
    }

    @DrawableRes
    public int getIcon() {
        return icon;
    }

    public void setIcon(@DrawableRes int icon) {
        this.icon = icon;
    }

    public int getNotificationCount() {
        return notificationCount;
    }

    public void setNotificationCount(int notificationCount) {
        if (notificationCount > 99) {
            this.notificationCount = 99;
        } else if (notificationCount < 0) {
            this.notificationCount = 0;
        } else {
            this.notificationCount = notificationCount;
        }
    }

    @InvocationMode
    public int getInvocationMode() {
        return invocationMode;
    }

    public void setInvocationMode(@InvocationMode int invocationMode) {
        this.invocationMode = invocationMode;
    }

    public void invoke(@Nullable Uri initialScreenshotUri, String... reportCategories) {
        InstabugSDKLogger.d(Constants.LOG_TAG, "[PluginPromptOption#invoke] invoking ...");
        if (onInvocationListener != null) {
            InstabugSDKLogger.d(Constants.LOG_TAG, "[PluginPromptOption#invoke] invocation listener is not null, proceeding...");
            onInvocationListener.onInvoke(initialScreenshotUri, reportCategories);
        }
    }

    public void invoke() {
        invoke(null);
    }

    public boolean isInitialScreenshotRequired() {
        return isInitialScreenshotRequired;
    }

    public void setInitialScreenshotRequired(boolean initialScreenshotRequired) {
        isInitialScreenshotRequired = initialScreenshotRequired;
    }

    @PromptOptionIdentifier
    public int getPromptOptionIdentifier() {
        return promptOptionIdentifier;
    }

    public void setPromptOptionIdentifier(@PromptOptionIdentifier int promptOptionIdentifier) {
        this.promptOptionIdentifier = promptOptionIdentifier;
    }

    @Nullable
    public ArrayList<PluginPromptOption> getSubOptions() {
        return subOptions;
    }

    public void setSubOptions(@Nullable ArrayList<PluginPromptOption> subOptions) {
        this.subOptions = subOptions;
    }

    @Nullable
    public PluginPromptOption getParent() {
        return parent;
    }

    public void setParent(@Nullable PluginPromptOption parent) {
        if (parent != null) {
            this.parent = parent;
        }
    }

    public static class CustomComparator implements Comparator<PluginPromptOption>, Serializable {
        @Override
        public int compare(PluginPromptOption o1, PluginPromptOption o2) {
            return o1.getOrder() - o2.getOrder();
        }
    }


    public void setOnInvocationListener(@Nullable OnInvocationListener onInvocationListener) {
        this.onInvocationListener = onInvocationListener;
    }

    public interface OnInvocationListener {
        void onInvoke(@Nullable Uri initialScreenshotUri, String... reportCategories);
    }

    @IntDef({PromptOptionIdentifier.BUG_REPORT, PromptOptionIdentifier.FEEDBACK,
            PromptOptionIdentifier.CHAT_LIST,
            PromptOptionIdentifier.ASK_QUESTION})
    public @interface PromptOptionIdentifier {
        int BUG_REPORT = 0;
        int FEEDBACK = 1;
        int CHAT_LIST = 2;
        int ASK_QUESTION = 3;
    }

}
