package com.instabug.library.core.eventbus.instabugeventbus.operators

import com.instabug.library.core.eventbus.instabugeventbus.AbstractOperatorEventBus
import com.instabug.library.core.eventbus.instabugeventbus.InstabugEventBus

class DistinctBy<T, Y>(source: InstabugEventBus<T>, private inline val key: (T) -> Y) :
    AbstractOperatorEventBus<T, T>(source) {

    private var lastItem: Y? = null
    override fun handleEvent(event: T) {
        val currentItem = key(event)
        event.takeIf { lastItem != currentItem }
            ?.also { lastItem = currentItem }
            ?.let(::post)
    }
}