package com.instabug.library;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.instabug.library.internal.utils.stability.execution.Executable;
import com.instabug.library.internal.utils.stability.execution.ReturnableExecutable;
import com.instabug.library.internal.utils.stability.handler.exception.ExceptionHandler;

import java.lang.reflect.Field;
import java.lang.reflect.Method;

/**
 * Created by tarek on 3/25/17.
 */

public class ReflectionUtils {

    private static final String TAG = "ReflectionUtils";
    private static final ExceptionHandler HANDLER = new ExceptionHandler().withPenaltyLog(TAG);

    @Nullable
    public static Field getField(@NonNull final Class clazz, @NonNull final String fieldName) {
        return HANDLER.executeAndGet(new ReturnableExecutable<Field>() {
            @Override
            public Field execute() throws Exception {
                Field f = clazz.getDeclaredField(fieldName);
                f.setAccessible(true);
                return f;
            }
        });
    }

    @Nullable
    public static Object getValue(@NonNull final Field field, @NonNull final Object instance) {
        return HANDLER.executeAndGet(new ReturnableExecutable<Object>() {
            @Override
            @Nullable
            public Object execute() throws Exception {
                return field.get(instance);
            }
        });
    }

    public static void setValue(@NonNull final Field field,
                                @NonNull final Object instance,
                                @NonNull final Object value) {
        HANDLER.execute(new Executable() {
            @Override
            public void execute() throws Exception {
                field.set(instance, value);
            }
        });
    }

    @Nullable
    public static Method getMethod(@NonNull final Class clazz, @NonNull final String methodName) {
        return HANDLER.executeAndGet(new ReturnableExecutable<Method>() {
            @Override
            @Nullable
            public Method execute() {
                Method[] methods = clazz.getDeclaredMethods();
                for (Method method : methods) {
                    if (method.getName().equals(methodName)) {
                        method.setAccessible(true);
                        return method;
                    }
                }
                return null;
            }
        });
    }

    @Nullable
    public static Method getMethod(@NonNull final Class clazz,
                                   @NonNull final String methodName,
                                   @NonNull final Class... parameterType) {
        return HANDLER.executeAndGet(new ReturnableExecutable<Method>() {
            @Override
            @Nullable
            public Method execute() {
                Method[] methods = clazz.getMethods();
                for (Method method : methods) {
                    if (method.getName().equals(methodName)
                            && method.getParameterTypes().length == parameterType.length) {
                        for (int i = 0; i < method.getParameterTypes().length; i++) {
                            if (method.getParameterTypes()[i] == parameterType[i]) {
                                if (i == method.getParameterTypes().length - 1) {
                                    method.setAccessible(true);
                                    return method;
                                }
                            } else {
                                break;
                            }
                        }
                    }
                }
                return null;
            }
        });
    }

    public static void invokeMethod(@NonNull final Object instance,
                                    @NonNull final Method method,
                                    @NonNull final Object... args) {
        HANDLER.execute(new Executable() {
            @Override
            public void execute() throws Exception {
                method.invoke(instance, args);
            }
        });
    }
}
