package com.instabug.library;

import androidx.annotation.IntDef;
import androidx.annotation.Keep;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

import static com.instabug.library.Platform.ANDROID;
import static com.instabug.library.Platform.CORDOVA;
import static com.instabug.library.Platform.FLUTTER;
import static com.instabug.library.Platform.RN;
import static com.instabug.library.Platform.UNITY;
import static com.instabug.library.Platform.XAMARIN;

@Keep
@Retention(RetentionPolicy.RUNTIME)
@IntDef({
        ANDROID,
        RN,
        XAMARIN,
        CORDOVA,
        UNITY,
        FLUTTER
})
public @interface Platform {
    int ANDROID = 2;
    int RN = 4;
    int XAMARIN = 5;
    int CORDOVA = 6;
    int UNITY = 7;
    int FLUTTER = 8;
}