package com.instabug.library;

import com.instabug.library.util.InstabugSDKLogger;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

public class InstabugStateProvider {

    @Nullable
    private static InstabugStateProvider instance = null;
    @NonNull
    private InstabugState state = InstabugState.BUILDING;

    private InstabugStateProvider() {
        // disable constructor instantiation.
    }

    public synchronized static InstabugStateProvider getInstance() {
        if (instance == null) {
            instance = new InstabugStateProvider();
        }
        return instance;
    }

    @NonNull
    public InstabugState getState() {
        return state;
    }

    public void setState(@NonNull InstabugState state) {
        InstabugSDKLogger.d(Constants.LOG_TAG, "Setting Instabug SDK state to " + state.name());
        this.state = state;
    }
}
