package com.instabug.library;

import androidx.annotation.StringDef;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

import static com.instabug.library.Constants.LogPlaceHolders.EMPTY_EMAIL;
import static com.instabug.library.Constants.LogPlaceHolders.EMPTY_USERNAME;
import static com.instabug.library.Constants.LogPlaceHolders.NON_EMPTY_EMAIL;
import static com.instabug.library.Constants.LogPlaceHolders.NON_EMPTY_USERNAME;
import static com.instabug.library.Constants.NetworkParam.APP_TOKEN;
import static com.instabug.library.Constants.NetworkParam.EMAIL;
import static com.instabug.library.Constants.NetworkParam.UUID;

/**
 * @author mSobhy
 */
public class Constants {

    public static final String LOG_TAG = "IBG-Core";
    public static final String FEATURE_NAME = "Sessions";
    public static final String USER_STEPS_EXECUTOR_KEY = "USER-STEPS";

    @StringDef({APP_TOKEN, UUID, EMAIL})
    @Retention(RetentionPolicy.SOURCE)
    public @interface NetworkParam {
        String APP_TOKEN = "application_token";
        String UUID = "uuid";
        String EMAIL = "email";
    }

    @StringDef({EMPTY_USERNAME, NON_EMPTY_USERNAME, EMPTY_EMAIL, NON_EMPTY_EMAIL})
    @Retention(RetentionPolicy.SOURCE)
    public @interface LogPlaceHolders {
        String EMPTY_USERNAME = "empty_username";
        String NON_EMPTY_USERNAME = "non-empty-username";
        String EMPTY_EMAIL = "empty-email";
        String NON_EMPTY_EMAIL = "non-empty-email";
    }

    public static class IntentParams {
        public static final int AUDIO_RECORDING_PERMISSION_REQUEST_CODE = 1;
    }
}
