/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.view.pagerindicator;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import androidx.annotation.Nullable;
import com.instabug.library.R;
import com.instabug.library.view.ViewUtils;
import com.instabug.library.view.pagerindicator.a;
import java.util.ArrayList;

public final class DotIndicator
extends RelativeLayout {
    private static final int DEFAULT_NUMBER_OF_DOTS = 1;
    private static final int DEFAULT_SELECTED_DOT_INDEX = 0;
    private static final int DEFAULT_UNSELECTED_DOT_DIAMETER_DP = 6;
    private static final int DEFAULT_SELECTED_DOT_DIAMETER_DP = 9;
    private static final int DEFAULT_UNSELECTED_DOT_COLOR = -1;
    private static final int DEFAULT_SELECTED_DOT_COLOR = -1;
    private static final int DEFAULT_SPACING_BETWEEN_DOTS_DP = 7;
    private static final int DEFAULT_DOT_TRANSITION_DURATION_MS = 200;
    private final ArrayList<a> dots;
    private int numberOfDots;
    private int selectedDotIndex;
    private int unselectedDotDiameterPx;
    private int selectedDotDiameterPx;
    private int unselectedDotColor;
    private int selectedDotColor;
    private int spacingBetweenDotsPx;
    private int dotTransitionDuration;

    /*
     * WARNING - void declaration
     */
    public DotIndicator(Context context) {
        this((Context)var1_1, null);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DotIndicator(Context context, @Nullable AttributeSet attrs) {
        this((Context)var1_1, (AttributeSet)var2_2, 0);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public DotIndicator(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        ArrayList arrayList;
        void var3_3;
        void var2_2;
        void var1_1;
        DotIndicator dotIndicator = this_;
        super((Context)var1_1, (AttributeSet)var2_2, (int)var3_3);
        Object this_ = arrayList;
        arrayList = new ArrayList();
        dotIndicator.dots = this_;
        dotIndicator.init((AttributeSet)var2_2, (int)var3_3);
    }

    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE", "CustomViewStyleable"})
    private void init(@Nullable AttributeSet attrs, int defStyleAttr) {
        int n2;
        TypedArray typedArray;
        DotIndicator dotIndicator = this;
        typedArray = dotIndicator.getContext().obtainStyledAttributes((AttributeSet)typedArray, R.styleable.IBDotIndicator, n2, 0);
        DotIndicator dotIndicator2 = this;
        int n3 = ViewUtils.convertDpToPx(dotIndicator2.getContext(), 9.0f);
        int n4 = ViewUtils.convertDpToPx(dotIndicator2.getContext(), 6.0f);
        n2 = ViewUtils.convertDpToPx(dotIndicator2.getContext(), 7.0f);
        this.numberOfDots = typedArray.getInt(R.styleable.IBDotIndicator_ibViewPagerNumberOfDots, 1);
        this.selectedDotIndex = typedArray.getInt(R.styleable.IBDotIndicator_ibViewPagerSelectedDotIndex, 0);
        this.unselectedDotDiameterPx = typedArray.getDimensionPixelSize(R.styleable.IBDotIndicator_ibViewPagerUnselectedDotDiameter, n4);
        this.selectedDotDiameterPx = typedArray.getDimensionPixelSize(R.styleable.IBDotIndicator_ibViewPagerSelectedDotDiameter, n3);
        this.unselectedDotColor = typedArray.getColor(R.styleable.IBDotIndicator_ibViewPagerUnselectedDotColor, -1);
        this.selectedDotColor = typedArray.getColor(R.styleable.IBDotIndicator_ibViewPagerSelectedDotColor, -1);
        this.spacingBetweenDotsPx = typedArray.getDimensionPixelSize(R.styleable.IBDotIndicator_ibViewPagerSpacingBetweenDots, n2);
        this.dotTransitionDuration = typedArray.getDimensionPixelSize(R.styleable.IBDot_ibViewPagerTransitionDuration, 200);
        typedArray.recycle();
        dotIndicator.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
        dotIndicator.setGravity(17);
        dotIndicator.reflectParametersInView();
    }

    private void reflectParametersInView() {
        DotIndicator dotIndicator = this;
        dotIndicator.removeAllViews();
        dotIndicator.dots.clear();
        for (int i2 = 0; i2 < this.numberOfDots; ++i2) {
            RelativeLayout.LayoutParams layoutParams;
            a a2;
            a a3 = a2;
            a3(this.getContext());
            a2.f(this.unselectedDotDiameterPx).d(this.selectedDotDiameterPx).c(this.selectedDotColor).e(this.unselectedDotColor).g(this.dotTransitionDuration);
            if (i2 == this.selectedDotIndex) {
                a3.a(false);
            } else {
                a3.b(false);
            }
            DotIndicator dotIndicator2 = this;
            int n2 = Math.max(dotIndicator2.selectedDotDiameterPx, this.unselectedDotDiameterPx);
            int n3 = i2 * (dotIndicator2.spacingBetweenDotsPx + this.unselectedDotDiameterPx);
            RelativeLayout.LayoutParams layoutParams2 = layoutParams;
            int n4 = n2;
            layoutParams2(n4, n4);
            layoutParams.setMargins(n3, 0, 0, 0);
            if (Build.VERSION.SDK_INT >= 17) {
                layoutParams2.setMarginStart(n3);
            }
            DotIndicator dotIndicator3 = this;
            a a4 = a3;
            a4.setLayoutParams((ViewGroup.LayoutParams)layoutParams2);
            dotIndicator3.addView((View)a4);
            dotIndicator3.dots.add(i2, a3);
        }
    }

    public void redrawDots() {
        this.reflectParametersInView();
    }

    /*
     * WARNING - void declaration
     */
    public void setUnselectedDotDiameterPx(int unselectedDotDiameterPx) {
        void var1_1;
        this.unselectedDotDiameterPx = var1_1;
        this.reflectParametersInView();
    }

    /*
     * WARNING - void declaration
     */
    public void setUnselectedDotDiameterDp(int unselectedDotDiameterDp) {
        void var1_1;
        DotIndicator dotIndicator = this;
        dotIndicator.setUnselectedDotDiameterPx(ViewUtils.convertDpToPx(dotIndicator.getContext(), (float)var1_1));
    }

    public int getUnselectedDotDiameter() {
        return this.unselectedDotDiameterPx;
    }

    /*
     * WARNING - void declaration
     */
    public void setSelectedDotDiameterPx(int selectedDotDiameterPx) {
        void var1_1;
        this.selectedDotDiameterPx = var1_1;
        this.reflectParametersInView();
    }

    /*
     * WARNING - void declaration
     */
    public void setSelectedDotDiameterDp(int selectedDotDiameterDp) {
        void var1_1;
        DotIndicator dotIndicator = this;
        dotIndicator.setSelectedDotDiameterPx(ViewUtils.convertDpToPx(dotIndicator.getContext(), (float)var1_1));
    }

    public int getSelectedDotDiameter() {
        return this.selectedDotDiameterPx;
    }

    public int getUnselectedDotColor() {
        return this.unselectedDotColor;
    }

    /*
     * WARNING - void declaration
     */
    public void setUnselectedDotColor(int unselectedDotColor) {
        void var1_1;
        this.unselectedDotColor = var1_1;
        this.reflectParametersInView();
    }

    public int getSelectedDotColor() {
        return this.selectedDotColor;
    }

    /*
     * WARNING - void declaration
     */
    public void setSelectedDotColor(int selectedDotColor) {
        void var1_1;
        this.selectedDotColor = var1_1;
        this.reflectParametersInView();
    }

    /*
     * WARNING - void declaration
     */
    public void setSpacingBetweenDotsPx(int spacingBetweenDotsPx) {
        void var1_1;
        this.spacingBetweenDotsPx = var1_1;
        this.reflectParametersInView();
    }

    /*
     * WARNING - void declaration
     */
    public void setSpacingBetweenDotsDp(int spacingBetweenDotsDp) {
        void var1_1;
        DotIndicator dotIndicator = this;
        dotIndicator.setSpacingBetweenDotsPx(ViewUtils.convertDpToPx(dotIndicator.getContext(), (float)var1_1));
    }

    public int getSpacingBetweenDots() {
        return this.spacingBetweenDotsPx;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setSelectedItem(int index, boolean animate) {
        void var2_2;
        if (this.dots.isEmpty()) return;
        try {
            if (this.selectedDotIndex < this.dots.size()) {
                this.dots.get(this.selectedDotIndex).b((boolean)var2_2);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IndexOutOfBoundsException();
        }
        {
            void var1_1;
            this.dots.get((int)var1_1).a((boolean)var2_2);
            this.selectedDotIndex = var1_1;
            return;
        }
    }

    public int getSelectedItemIndex() {
        return this.selectedDotIndex;
    }

    public int getNumberOfItems() {
        return this.numberOfDots;
    }

    /*
     * WARNING - void declaration
     */
    public void setNumberOfItems(int numberOfItems) {
        void var1_1;
        this.numberOfDots = var1_1;
        this.reflectParametersInView();
    }

    public int getTransitionDuration() {
        return this.dotTransitionDuration;
    }

    /*
     * WARNING - void declaration
     */
    public void setTransitionDuration(int transitionDurationMs) {
        void var1_1;
        this.dotTransitionDuration = var1_1;
        this.reflectParametersInView();
    }

    public void setVisibility(boolean show) {
        int n2 = show ? 0 : 4;
        this.setVisibility(n2);
    }

    public boolean isVisible() {
        return this.getVisibility() == 0;
    }
}

