/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.util;

import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.Pair;
import android.view.KeyCharacterMap;
import android.view.ViewConfiguration;
import android.view.WindowInsets;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.instabug.library.core.InstabugCore;

public class ScreenUtility {
    public static int getScreenHeight(@Nullable Context context) {
        if (context != null) {
            Context context2;
            return context2.getResources().getDisplayMetrics().heightPixels;
        }
        return 0;
    }

    public static int getWindowHeight(Activity activity) {
        Activity activity2;
        if (activity != null && (activity2 = activity2.getWindow()) != null) {
            return activity2.getDecorView().getHeight();
        }
        return 0;
    }

    public static int getWindowWidth(Activity activity) {
        Activity activity2;
        if (activity != null && (activity2 = activity2.getWindow()) != null) {
            return activity2.getDecorView().getWidth();
        }
        return 0;
    }

    public static boolean isLandscape(Activity activity) {
        Activity activity2;
        DisplayMetrics displayMetrics;
        DisplayMetrics displayMetrics2 = displayMetrics;
        displayMetrics2();
        activity2.getWindowManager().getDefaultDisplay().getMetrics(displayMetrics2);
        return displayMetrics.widthPixels > displayMetrics2.heightPixels;
    }

    public static boolean hasNavBar(Context context) {
        Context context2;
        if (context == null) {
            return false;
        }
        boolean bl = KeyCharacterMap.deviceHasKey((int)4);
        return !ViewConfiguration.get((Context)context2).hasPermanentMenuKey() || !bl;
        {
        }
    }

    public static int getNavigationBarWidth(Resources resources) {
        int n2 = resources.getIdentifier("navigation_bar_width", "dimen", "android");
        if (n2 > 0) {
            Resources resources2;
            return resources2.getDimensionPixelSize(n2);
        }
        return 0;
    }

    public static int getNavigationBarHeight(Resources resources) {
        int n2 = resources.getIdentifier("navigation_bar_height", "dimen", "android");
        if (n2 > 0) {
            Resources resources2;
            return resources2.getDimensionPixelSize(n2);
        }
        return 0;
    }

    public static int getBottomInsets(Activity activity) {
        Activity activity2;
        int n2 = Build.VERSION.SDK_INT;
        if (n2 >= 23) {
            if ((activity2 = activity2.getWindow()) != null) {
                if ((activity2 = activity2.getDecorView().getRootWindowInsets()) != null && n2 >= 32) {
                    return activity2.getInsets((int)WindowInsets.Type.systemBars()).bottom;
                }
                if (activity2 != null) {
                    return activity2.getStableInsetBottom();
                }
            }
        } else if (ScreenUtility.hasNavBar((Context)activity2) && InstabugCore.getTargetActivity() != null) {
            return ScreenUtility.getNavigationBarHeight(activity2.getResources());
        }
        return 0;
    }

    @Nullable
    public static Pair<Integer, Integer> getEdgesCutoutIfApplicable(@NonNull Activity activity) {
        Activity activity2;
        if (Build.VERSION.SDK_INT < 28) {
            return null;
        }
        if (ScreenUtility.shouldSkipCutoutReduction(activity2.getWindow().getAttributes().layoutInDisplayCutoutMode)) {
            return null;
        }
        return ScreenUtility.getEdgesCutoutCompat(activity2);
    }

    private static boolean shouldSkipCutoutReduction(int cutoutMode) {
        if (Build.VERSION.SDK_INT >= 30) {
            int n2;
            return n2 == 3 || n2 == 1;
            {
            }
        }
        return false;
    }

    @Nullable
    private static Pair<Integer, Integer> getEdgesCutoutCompat(@NonNull Activity activity) {
        if (Build.VERSION.SDK_INT >= 29) {
            Activity activity2;
            if ((activity2 = activity2.getWindowManager().getDefaultDisplay().getCutout()) == null) {
                return null;
            }
            return new Pair((Object)activity2.getSafeInsetLeft(), (Object)activity2.getSafeInsetRight());
        }
        return null;
    }
}

