/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.tracking;

import android.app.Activity;
import android.app.Application;
import android.content.ComponentCallbacks;
import android.content.res.Configuration;
import android.view.MotionEvent;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import com.instabug.library.Feature;
import com.instabug.library.InstabugState;
import com.instabug.library.InstabugStateProvider;
import com.instabug.library._InstabugActivity;
import com.instabug.library.core.CurrentFragmentLifeCycleEventBus;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.core.eventbus.CurrentActivityConfigurationChange;
import com.instabug.library.core.eventbus.CurrentActivityLifeCycleEventBus;
import com.instabug.library.d;
import com.instabug.library.internal.servicelocator.CoreServiceLocator;
import com.instabug.library.sessionreplay.di.a;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.tracking.ActivityLifeCycleEvent;
import com.instabug.library.tracking.FragmentLifeCycleEvent;
import com.instabug.library.tracking.c;
import com.instabug.library.tracking.g;
import com.instabug.library.tracking.h;
import com.instabug.library.tracking.q;
import com.instabug.library.tracking.r;
import com.instabug.library.tracking.v;
import com.instabug.library.tracking.w;
import com.instabug.library.util.InstabugSDKLogger;
import java.lang.ref.WeakReference;
import java.util.concurrent.Future;

public class InstabugInternalTrackingDelegate {
    private static volatile InstabugInternalTrackingDelegate INSTANCE;
    private static final String FRAGMENT_NAV_HOST_NAME = "androidx.navigation.fragment.NavHostFragment";
    private boolean isRegistered = false;
    private final g currentActivityMonitor;
    private final r activityLifecycleListener;
    @Nullable
    private WeakReference<Fragment> lastResumedFragment;
    @Nullable
    private volatile WeakReference<Activity> currentActivity;
    @Nullable
    private volatile WeakReference<Activity> currentRealActivity;
    @Nullable
    private volatile WeakReference<Activity> lastStoppedActivity;
    private int startedActivitiesNumber = 0;
    private final int platform = SettingsManager.getInstance().getCurrentPlatform();
    private final c activityMetaDataProvider;

    public static void init(@NonNull Application application) {
        if (INSTANCE == null) {
            Application application2;
            INSTANCE = new InstabugInternalTrackingDelegate(application2);
            return;
        }
    }

    public static InstabugInternalTrackingDelegate getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private InstabugInternalTrackingDelegate(@NonNull Application application) {
        void var1_1;
        g g2;
        g g3 = g2;
        InstabugInternalTrackingDelegate instabugInternalTrackingDelegate = this;
        g g4 = g3;
        g4();
        instabugInternalTrackingDelegate.currentActivityMonitor = g4;
        instabugInternalTrackingDelegate.activityLifecycleListener = new r();
        g2.a((Application)var1_1);
        this.activityMetaDataProvider = CoreServiceLocator.getActivityMetaDataProvider();
        this.registerLifecycleListeners((Application)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private boolean isNavHostFragment(Fragment fragment) {
        void var1_1;
        if (fragment == null) {
            return false;
        }
        return FRAGMENT_NAV_HOST_NAME.equals(var1_1.getClass().getName());
    }

    private boolean isUserTrackingStepsEnable() {
        return d.d().b((Object)"TRACK_USER_STEPS") == Feature.State.ENABLED && !((Object)((Object)InstabugStateProvider.getInstance().getState())).equals((Object)InstabugState.DISABLED);
    }

    private boolean isInstabugInEnabledState() {
        return ((Object)((Object)InstabugStateProvider.getInstance().getState())).equals((Object)InstabugState.ENABLED);
    }

    private boolean isNotInstabugActivity(Activity activity) {
        return activity instanceof _InstabugActivity ^ true;
    }

    /*
     * WARNING - void declaration
     */
    public void onApplicationCreated(Application application) {
        if (this.isUserTrackingStepsEnable()) {
            void var1_1;
            InstabugSDKLogger.v("IBG-Core", var1_1.getClass().getSimpleName() + " created");
            w.a().a(var1_1.getClass().getName(), "APPLICATION_CREATED");
            return;
        }
    }

    public int getStartedActivitiesNumber() {
        return this.startedActivitiesNumber;
    }

    void handleActivityCreatedEvent(Activity activity) {
        String string2;
        if (((InstabugInternalTrackingDelegate)((Object)this_)).isNotInstabugActivity((Activity)string2)) {
            if (((InstabugInternalTrackingDelegate)((Object)this_)).isUserTrackingStepsEnable()) {
                InstabugSDKLogger.v("IBG-Core", ((InstabugInternalTrackingDelegate)((Object)this_)).activityMetaDataProvider.c((Activity)string2) + " created");
                w.a().a(((InstabugInternalTrackingDelegate)((Object)this_)).activityMetaDataProvider.e((Activity)string2), "ACTIVITY_CREATED");
            }
            if (((InstabugInternalTrackingDelegate)((Object)this_)).isInstabugInEnabledState() && ((InstabugInternalTrackingDelegate)((Object)this_)).platform == 2) {
                InstabugInternalTrackingDelegate instabugInternalTrackingDelegate = this_;
                String this_ = instabugInternalTrackingDelegate.activityMetaDataProvider.c((Activity)string2);
                string2 = instabugInternalTrackingDelegate.activityMetaDataProvider.e((Activity)string2);
                CoreServiceLocator.getReproStepsProxy().addVisualUserStep("ACTIVITY_CREATED", this_, string2, null);
            }
            CurrentActivityLifeCycleEventBus.INSTANCE.post(ActivityLifeCycleEvent.CREATED);
            return;
        }
    }

    void handleActivityStartedEvent(Activity activity) {
        String string2;
        ++((InstabugInternalTrackingDelegate)((Object)this_)).startedActivitiesNumber;
        if (((InstabugInternalTrackingDelegate)((Object)this_)).isNotInstabugActivity((Activity)string2)) {
            if (((InstabugInternalTrackingDelegate)((Object)this_)).isUserTrackingStepsEnable()) {
                InstabugSDKLogger.v("IBG-Core", ((InstabugInternalTrackingDelegate)((Object)this_)).activityMetaDataProvider.c((Activity)string2) + " started");
                w.a().a(((InstabugInternalTrackingDelegate)((Object)this_)).activityMetaDataProvider.e((Activity)string2), "ACTIVITY_STARTED");
            }
            if (((InstabugInternalTrackingDelegate)((Object)this_)).isInstabugInEnabledState() && ((InstabugInternalTrackingDelegate)((Object)this_)).platform == 2) {
                InstabugInternalTrackingDelegate instabugInternalTrackingDelegate = this_;
                String this_ = instabugInternalTrackingDelegate.activityMetaDataProvider.c((Activity)string2);
                string2 = instabugInternalTrackingDelegate.activityMetaDataProvider.e((Activity)string2);
                CoreServiceLocator.getReproStepsProxy().addVisualUserStep("ACTIVITY_STARTED", this_, string2, null);
            }
        }
        CurrentActivityLifeCycleEventBus.INSTANCE.post(ActivityLifeCycleEvent.STARTED);
    }

    /*
     * WARNING - void declaration
     */
    void handleActivityResumedEvent(Activity activity) {
        void var1_1;
        if (this.isNotInstabugActivity((Activity)var1_1)) {
            if (this.isUserTrackingStepsEnable()) {
                InstabugSDKLogger.v("IBG-Core", this.activityMetaDataProvider.c((Activity)var1_1) + " resumed");
                w.a().a(this.activityMetaDataProvider.e((Activity)var1_1), "ACTIVITY_RESUMED");
            }
            if (this.isInstabugInEnabledState()) {
                InstabugInternalTrackingDelegate instabugInternalTrackingDelegate = this;
                String string2 = instabugInternalTrackingDelegate.activityMetaDataProvider.c((Activity)var1_1);
                String string3 = instabugInternalTrackingDelegate.activityMetaDataProvider.e((Activity)var1_1);
                CoreServiceLocator.getReproStepsProxy().addVisualUserStep("ACTIVITY_RESUMED", string2, string3, null);
            }
            CoreServiceLocator.getNavigableViewsTracker().c((Activity)var1_1);
            CurrentActivityLifeCycleEventBus.INSTANCE.post(ActivityLifeCycleEvent.RESUMED);
            q.a((Activity)var1_1);
            h.b().b(this.activityMetaDataProvider.e((Activity)var1_1));
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setCurrentActivity(Activity activity) {
        void var1_1;
        ((InstabugInternalTrackingDelegate)((Object)this_)).currentRealActivity = new WeakReference<void>(var1_1);
        if (((InstabugInternalTrackingDelegate)((Object)this_)).isNotInstabugActivity((Activity)var1_1)) {
            WeakReference<void> weakReference;
            InstabugInternalTrackingDelegate instabugInternalTrackingDelegate = this_;
            WeakReference<void> this_ = weakReference;
            weakReference = new WeakReference<void>(var1_1);
            instabugInternalTrackingDelegate.currentActivity = this_;
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    void handleActivityPausedEvent(Activity activity) {
        void var1_1;
        Object object = this.getCurrentActivity();
        if (this.isNotInstabugActivity((Activity)var1_1)) {
            if (object == null) {
                InstabugSDKLogger.w("IBG-Core", "No activity was set earlier than this call. Doing nothing");
                return;
            }
            if (!var1_1.equals(object)) {
                InstabugSDKLogger.w("IBG-Core", "You're trying to pause an activity that is not the current activity! Please make sure you're calling onCurrentActivityPaused and onCurrentActivityResumed on every activity");
                return;
            }
            InstabugInternalTrackingDelegate instabugInternalTrackingDelegate = this;
            object = instabugInternalTrackingDelegate.activityMetaDataProvider.e((Activity)var1_1);
            String string2 = instabugInternalTrackingDelegate.activityMetaDataProvider.c((Activity)var1_1);
            if (instabugInternalTrackingDelegate.isUserTrackingStepsEnable()) {
                InstabugSDKLogger.v("IBG-Core", string2 + " paused");
                w.a().a((String)object, "ACTIVITY_PAUSED");
            }
            if (this.isInstabugInEnabledState()) {
                CoreServiceLocator.getReproStepsProxy().addVisualUserStep("ACTIVITY_PAUSED", string2, (String)object, null);
            }
            CurrentActivityLifeCycleEventBus.INSTANCE.post(ActivityLifeCycleEvent.PAUSED);
        }
        CoreServiceLocator.getNavigableViewsTracker().b((Activity)var1_1);
    }

    void handleActivityStoppedEvent(Activity activity) {
        String string2;
        --((InstabugInternalTrackingDelegate)((Object)this_)).startedActivitiesNumber;
        ((InstabugInternalTrackingDelegate)((Object)this_)).lastStoppedActivity = new WeakReference<void>((void)string2);
        if (((InstabugInternalTrackingDelegate)((Object)this_)).isNotInstabugActivity((Activity)string2)) {
            if (((InstabugInternalTrackingDelegate)((Object)this_)).isUserTrackingStepsEnable()) {
                InstabugSDKLogger.v("IBG-Core", ((InstabugInternalTrackingDelegate)((Object)this_)).activityMetaDataProvider.c((Activity)string2) + " stopped");
                Future future = w.a().a(((InstabugInternalTrackingDelegate)((Object)this_)).activityMetaDataProvider.e((Activity)string2), "ACTIVITY_STOPPED");
                if (((InstabugInternalTrackingDelegate)((Object)this_)).startedActivitiesNumber == 0) {
                    a.m().a(future);
                }
            }
            if (((InstabugInternalTrackingDelegate)((Object)this_)).isInstabugInEnabledState()) {
                InstabugInternalTrackingDelegate instabugInternalTrackingDelegate = this_;
                String this_ = instabugInternalTrackingDelegate.activityMetaDataProvider.c((Activity)string2);
                string2 = instabugInternalTrackingDelegate.activityMetaDataProvider.e((Activity)string2);
                CoreServiceLocator.getReproStepsProxy().addVisualUserStep("ACTIVITY_STOPPED", this_, string2, null);
            }
        }
        CurrentActivityLifeCycleEventBus.INSTANCE.post(ActivityLifeCycleEvent.STOPPED);
    }

    /*
     * WARNING - void declaration
     */
    void handleActivityDestroyedEvent(Activity activity) {
        void var1_1;
        if (this.isNotInstabugActivity((Activity)var1_1)) {
            Object object;
            if (this.isUserTrackingStepsEnable()) {
                InstabugSDKLogger.v("IBG-Core", this.activityMetaDataProvider.c((Activity)var1_1) + " destroyed");
                w.a().a(this.activityMetaDataProvider.e((Activity)var1_1), "ACTIVITY_DESTROYED");
            }
            if (this.isInstabugInEnabledState()) {
                InstabugInternalTrackingDelegate instabugInternalTrackingDelegate = this;
                object = instabugInternalTrackingDelegate.activityMetaDataProvider.c((Activity)var1_1);
                String string2 = instabugInternalTrackingDelegate.activityMetaDataProvider.e((Activity)var1_1);
                CoreServiceLocator.getReproStepsProxy().addVisualUserStep("ACTIVITY_DESTROYED", (String)object, string2, null);
            }
            if ((object = this.getCurrentActivity()) != null && object == var1_1) {
                this.clearCurrentActivity();
            }
            CurrentActivityLifeCycleEventBus.INSTANCE.post(ActivityLifeCycleEvent.DESTROYED);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    void onFragmentAttached(Fragment fragment) {
        void var1_1;
        if (fragment != null && !this.isNavHostFragment((Fragment)var1_1)) {
            Activity activity = this.getCurrentActivity();
            if (activity != null && this.isUserTrackingStepsEnable()) {
                w.a().a(var1_1.getClass().getName(), this.activityMetaDataProvider.e(activity), "FRAGMENT_ATTACHED");
            }
            CurrentFragmentLifeCycleEventBus.getInstance().post(FragmentLifeCycleEvent.ATTACHED);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    void onFragmentViewCreated(Fragment fragment) {
        void var1_1;
        if (fragment != null && !this.isNavHostFragment((Fragment)var1_1)) {
            Activity activity = this.getCurrentActivity();
            if (activity != null && this.isUserTrackingStepsEnable()) {
                w.a().a(var1_1.getClass().getName(), this.activityMetaDataProvider.e(activity), "FRAGMENT_VIEW_CREATED");
            }
            CurrentFragmentLifeCycleEventBus.getInstance().post(FragmentLifeCycleEvent.VIEW_CREATED);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    void onFragmentStarted(Fragment fragment) {
        void var1_1;
        if (fragment != null && !this.isNavHostFragment((Fragment)var1_1)) {
            Activity activity = this.getCurrentActivity();
            if (activity != null && this.isUserTrackingStepsEnable()) {
                w.a().a(var1_1.getClass().getName(), this.activityMetaDataProvider.e(activity), "FRAGMENT_STARTED");
            }
            CurrentFragmentLifeCycleEventBus.getInstance().post(FragmentLifeCycleEvent.STARTED);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    void onFragmentResumed(Fragment fragment) {
        void var1_1;
        if (fragment != null && !this.isNavHostFragment((Fragment)var1_1)) {
            Activity activity;
            Activity activity2 = activity;
            activity = new WeakReference(var1_1);
            this.lastResumedFragment = activity2;
            activity2 = this.getCurrentActivity();
            if (activity2 != null && this.isUserTrackingStepsEnable()) {
                w.a().a(var1_1.getClass().getName(), this.activityMetaDataProvider.e(activity2), "FRAGMENT_RESUMED");
            }
            if (var1_1.getActivity() != null) {
                q.a((Activity)var1_1.getActivity());
            }
            CurrentFragmentLifeCycleEventBus.getInstance().post(FragmentLifeCycleEvent.RESUMED);
            h.b().c(var1_1.getClass().getName());
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    void onFragmentPaused(Fragment fragment) {
        void var1_1;
        if (fragment != null && !this.isNavHostFragment((Fragment)var1_1)) {
            this.lastResumedFragment = null;
            Activity activity = this.getCurrentActivity();
            if (activity != null && this.isUserTrackingStepsEnable()) {
                w.a().a(var1_1.getClass().getName(), this.activityMetaDataProvider.e(activity), "FRAGMENT_PAUSED");
            }
            CurrentFragmentLifeCycleEventBus.getInstance().post(FragmentLifeCycleEvent.PAUSED);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    void onFragmentStopped(Fragment fragment) {
        void var1_1;
        if (fragment != null && !this.isNavHostFragment((Fragment)var1_1)) {
            Activity activity = this.getCurrentActivity();
            if (activity != null && this.isUserTrackingStepsEnable()) {
                w.a().a(var1_1.getClass().getName(), this.activityMetaDataProvider.e(activity), "FRAGMENT_STOPPED");
            }
            CurrentFragmentLifeCycleEventBus.getInstance().post(FragmentLifeCycleEvent.STOPPED);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    void onFragmentDetached(Fragment fragment) {
        void var1_1;
        if (fragment != null && !this.isNavHostFragment((Fragment)var1_1)) {
            Activity activity = this.getCurrentActivity();
            if (activity != null && this.isUserTrackingStepsEnable()) {
                w.a().a(var1_1.getClass().getName(), this.activityMetaDataProvider.e(activity), "FRAGMENT_DETACHED");
            }
            CurrentFragmentLifeCycleEventBus.getInstance().post(FragmentLifeCycleEvent.DETACHED);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void onFragmentVisibilityChanged(boolean isVisible, Fragment fragment) {
        void var2_3;
        if (fragment != null && !((InstabugInternalTrackingDelegate)((Object)string2)).isNavHostFragment((Fragment)var2_3)) {
            Activity activity = ((InstabugInternalTrackingDelegate)((Object)string2)).getCurrentActivity();
            if (activity != null && ((InstabugInternalTrackingDelegate)((Object)string2)).isUserTrackingStepsEnable()) {
                void var1_1;
                w.a().a(var2_3.getClass().getName(), ((InstabugInternalTrackingDelegate)((Object)string2)).activityMetaDataProvider.e(activity), "Fragment visibility: " + (boolean)var1_1, "FRAGMENT_VISIBILITY_CHANGED");
            }
            if (((InstabugInternalTrackingDelegate)((Object)string2)).isInstabugInEnabledState()) {
                void v02 = var2_3;
                String string2 = v02.getClass().getSimpleName();
                String string3 = v02.getClass().getName();
                CoreServiceLocator.getReproStepsProxy().addVisualUserStep("FRAGMENT_VISIBILITY_CHANGED", string2, string3, null);
                return;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    void trackTouchEvent(MotionEvent event) {
        void var1_1;
        v.a().a((MotionEvent)var1_1);
    }

    @Nullable
    public Activity getCurrentActivity() {
        block3: {
            try {
                if (this.currentActivity != null) break block3;
                return null;
            }
            catch (Throwable throwable) {
                InstabugCore.reportError(throwable, "Error while retrieving current activity");
                return null;
            }
        }
        return (Activity)this.currentActivity.get();
    }

    @Nullable
    public Activity getLastStoppedActivity() {
        block3: {
            try {
                WeakReference<Activity> this_ = ((InstabugInternalTrackingDelegate)((Object)this_)).lastStoppedActivity;
                if (this_ != null) break block3;
                return null;
            }
            catch (Throwable throwable) {
                InstabugCore.reportError(throwable, "Error while retrieving stopped activity");
                return null;
            }
        }
        return (Activity)this_.get();
    }

    public void clearCurrentActivity() {
        block3: {
            try {
                if (this.currentActivity != null) break block3;
                return;
            }
            catch (Throwable throwable) {
                InstabugCore.reportError(throwable, "Error while clearing current activity");
                return;
            }
        }
        this.currentActivity.clear();
    }

    @Nullable
    public Activity getCurrentRealActivity() {
        block3: {
            try {
                if (this.currentRealActivity != null) break block3;
                return null;
            }
            catch (Throwable throwable) {
                InstabugCore.reportError(throwable, "Error while retrieving current real activity");
                return null;
            }
        }
        return (Activity)this.currentRealActivity.get();
    }

    @Nullable
    public Activity getTargetActivity() {
        InstabugInternalTrackingDelegate instabugInternalTrackingDelegate = this_;
        InstabugInternalTrackingDelegate this_ = null;
        Activity activity = instabugInternalTrackingDelegate.getCurrentActivity();
        if (activity != null && activity.getParent() != null) {
            this_ = activity.getParent();
            while (this_.getParent() != null) {
                this_ = this_.getParent();
            }
            return this_;
        }
        if (activity != null) {
            return activity;
        }
        return this_;
    }

    @Nullable
    public Object getLastSeenView() {
        WeakReference<Fragment> weakReference = this.lastResumedFragment;
        if (weakReference != null && weakReference.get() != null) {
            return this.lastResumedFragment.get();
        }
        return this.getTargetActivity();
    }

    /*
     * WARNING - void declaration
     */
    public void registerLifecycleListeners(Application application) {
        void var1_1;
        var1_1.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.activityLifecycleListener);
        var1_1.registerComponentCallbacks((ComponentCallbacks)this.activityLifecycleListener);
        this.isRegistered = true;
    }

    /*
     * WARNING - void declaration
     */
    public void unregisterLifecycleListeners(Application application) {
        void var1_1;
        InstabugSDKLogger.d("IBG-Core", "Unregistering activity lifecycle listener");
        var1_1.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.activityLifecycleListener);
        var1_1.unregisterComponentCallbacks((ComponentCallbacks)this.activityLifecycleListener);
        this.isRegistered = false;
    }

    public boolean isRegistered() {
        return this.isRegistered;
    }

    /*
     * WARNING - void declaration
     */
    void handleConfigurationChanged(Configuration newConfig) {
        void var1_1;
        if (((InstabugInternalTrackingDelegate)((Object)this_)).getTargetActivity() == null) {
            return;
        }
        CurrentActivityConfigurationChange this_ = CurrentActivityConfigurationChange.getInstance();
        this_.setNewConfig((Configuration)var1_1);
        CurrentActivityConfigurationChange.getInstance().post(this_);
    }
}

