/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.internal.storage.cache;

import android.annotation.SuppressLint;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.instabug.library.internal.storage.cache.Cache;
import com.instabug.library.internal.storage.cache.CacheChangedListener;
import com.instabug.library.internal.storage.cache.InMemoryCache;
import com.instabug.library.util.InstabugSDKLogger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CacheManager {
    public static final String DEFAULT_IN_MEMORY_CACHE_KEY = "DEFAULT_IN_MEMORY_CACHE_KEY";
    private static CacheManager INSTANCE;
    private final List<Cache> caches;

    public CacheManager() {
        InMemoryCache inMemoryCache;
        ArrayList<Cache> arrayList;
        ArrayList<Cache> arrayList2 = arrayList;
        arrayList2();
        ((CacheManager)((Object)this_)).caches = arrayList2;
        InMemoryCache this_ = inMemoryCache;
        inMemoryCache = new InMemoryCache(DEFAULT_IN_MEMORY_CACHE_KEY);
        arrayList.add(this_);
    }

    public static synchronized CacheManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new CacheManager();
        }
        return INSTANCE;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Nullable
    public Cache getCache(String cacheId) {
        void var1_1;
        List<Cache> this_;
        CacheManager cacheManager = this_;
        List<Cache> list = cacheManager.caches;
        // MONITORENTER : list
        for (Cache cache : cacheManager.caches) {
            if (!cache.getId().equals(var1_1)) continue;
            // MONITOREXIT : list
            return cache;
        }
        InstabugSDKLogger.v("IBG-Core", "No cache with this ID was found " + (String)var1_1 + " returning null");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public Cache addCache(Cache cache) {
        void var1_1;
        Object object = this.getCache(var1_1.getId());
        if (object != null) {
            return object;
        }
        object = this.caches;
        synchronized (object) {
            this.caches.add((Cache)var1_1);
            return var1_1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public boolean deleteCache(String cacheId) {
        void var1_1;
        Cache cache = ((CacheManager)((Object)this_)).getCache((String)var1_1);
        if (cache != null) {
            CacheManager cacheManager = this_;
            List<Cache> this_ = cacheManager.caches;
            synchronized (this_) {
                return cacheManager.caches.remove(cache);
            }
        }
        InstabugSDKLogger.v("IBG-Core", "No cache was this ID was found " + (String)var1_1 + " to be deleted");
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public boolean cacheExists(String cacheId) {
        void var1_1;
        return this.getCache((String)var1_1) != null;
    }

    /*
     * WARNING - void declaration
     */
    public boolean subscribe(String cacheId, CacheChangedListener cacheChangedListener) {
        void var1_1;
        if (((CacheManager)this).cacheExists((String)var1_1) && (this = ((CacheManager)this).getCache((String)var1_1)) != null) {
            void var2_2;
            return ((Cache)this).addOnCacheChangedListener(var2_2);
        }
        throw new IllegalArgumentException("No cache exists with this ID to subscribe to");
    }

    /*
     * WARNING - void declaration
     */
    public boolean unSubscribe(String cacheId, CacheChangedListener cacheChangedListener) {
        void var1_1;
        if (((CacheManager)this).cacheExists((String)var1_1) && (this = ((CacheManager)this).getCache((String)var1_1)) != null) {
            void var2_2;
            return ((Cache)this).removeOnCacheChangedListener(var2_2);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void invalidateAllCaches() {
        CacheManager cacheManager = this;
        List<Cache> list = cacheManager.caches;
        // MONITORENTER : list
        Iterator<Cache> iterator = cacheManager.caches.iterator();
        while (iterator.hasNext()) {
            this.invalidateCache(iterator.next());
        }
        InstabugSDKLogger.v("IBG-Core", "All caches have been invalidated");
    }

    /*
     * WARNING - void declaration
     */
    public void invalidateCache(Cache cache) {
        if (cache != null) {
            void var1_1;
            var1_1.invalidate();
            InstabugSDKLogger.v("IBG-Core", "Cache with the ID " + var1_1.getId() + " have been invalidated");
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void invalidateAllCachesForIdentifyingUsers() {
        CacheManager cacheManager = this;
        List<Cache> list = cacheManager.caches;
        // MONITORENTER : list
        for (Cache cache : cacheManager.caches) {
            if (cache.getId().equals("user_attributes_memory_cache") || cache.getId().equals("user_attributes_disk_cache")) continue;
            this.invalidateCache(cache);
        }
        InstabugSDKLogger.v("IBG-Core", "All caches have been invalidated except user attributes cache");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void invalidateAllCachesButUserAttributes() {
        CacheManager cacheManager = this;
        List<Cache> list = cacheManager.caches;
        // MONITORENTER : list
        for (Cache cache : cacheManager.caches) {
            if (cache.getId().equalsIgnoreCase("attrs") || cache.getId().equalsIgnoreCase("/user_attributes.cache") || cache.getId().equalsIgnoreCase("user_attributes_disk_cache") || cache.getId().equalsIgnoreCase("user_attributes_memory_cache")) continue;
            this.invalidateCache(cache);
        }
        InstabugSDKLogger.v("IBG-Core", "All caches have been invalidated");
    }

    /*
     * WARNING - void declaration
     */
    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public <K, V> void migrateCache(@NonNull String migratingFromCacheKey, @NonNull String migratingToCacheKey, KeyExtractor<K, V> extractor) throws IllegalArgumentException {
        void var3_3;
        void var2_2;
        void var1_1;
        Cache cache = this.getCache((String)var1_1);
        Cache cache2 = this.getCache((String)var2_2);
        InstabugSDKLogger.v("IBG-Core", "Caches to be migrated " + cache + " - " + cache2);
        if (cache == null) {
            InstabugSDKLogger.v("IBG-Core", "No cache with these key(" + (String)var1_1 + ") was found to migrate from");
            return;
        }
        if (cache2 == null) {
            InMemoryCache inMemoryCache;
            cache2 = inMemoryCache;
            inMemoryCache = new InMemoryCache((String)var2_2);
            this.addCache(cache2);
        }
        this.migrateCache(cache, cache2, (KeyExtractor<K, V>)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public <K, V> void migrateCache(@NonNull Cache<K, V> migratingFromCache, @NonNull Cache<K, V> migratingToCache, KeyExtractor<K, V> extractor) {
        void var2_2;
        Object e2;
        InstabugSDKLogger.v("IBG-Core", "Invalidated migratingTo cache");
        if (migratingToCache != null && e2 != null) {
            var2_2.invalidate();
            Iterator iterator = ((Cache)e2).getValues();
            if (iterator != null && !iterator.isEmpty()) {
                iterator = iterator.iterator();
                while (iterator.hasNext()) {
                    void var3_3;
                    e2 = iterator.next();
                    if (e2 == null) continue;
                    InstabugSDKLogger.v("IBG-Core", "Adding value " + e2 + " with key " + var3_3.extractKey(e2));
                    var2_2.put(var3_3.extractKey(e2), e2);
                }
                return;
            }
            InstabugSDKLogger.v("IBG-Core", "Cache to migrate from doesn't contain any elements, not going further with the migration");
            return;
        }
        InstabugSDKLogger.e("IBG-Core", "cache migration process got failure, migratingToCache: " + var2_2 + ", migratingFromCache: " + e2);
    }

    public static abstract class KeyExtractor<K, V> {
        public abstract K extractKey(V var1);
    }
}

