/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.core;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.WorkerThread;
import com.instabug.library.Feature;
import com.instabug.library.Instabug;
import com.instabug.library.InstabugColorTheme;
import com.instabug.library.OnSdkInvokedCallback;
import com.instabug.library.Platform;
import com.instabug.library.core.eventbus.AutoScreenRecordingEventBus;
import com.instabug.library.core.plugin.Plugin;
import com.instabug.library.core.plugin.PluginPromptOption;
import com.instabug.library.core.plugin.c;
import com.instabug.library.d;
import com.instabug.library.diagnostics.IBGDiagnostics;
import com.instabug.library.f;
import com.instabug.library.h;
import com.instabug.library.internal.contentprovider.InstabugApplicationProvider;
import com.instabug.library.internal.orchestrator.Action;
import com.instabug.library.internal.orchestrator.ActionsOrchestrator;
import com.instabug.library.internal.servicelocator.CoreServiceLocator;
import com.instabug.library.internal.servicelocator.application.b;
import com.instabug.library.internal.storage.ProcessedBytes;
import com.instabug.library.internal.storage.cache.db.userAttribute.UserAttributeCacheManager;
import com.instabug.library.internal.video.InternalAutoScreenRecorderHelper;
import com.instabug.library.internal.video.ScreenRecordingServiceAction;
import com.instabug.library.invocation.InstabugInvocationEvent;
import com.instabug.library.invocation.util.InstabugVideoRecordingButtonPosition;
import com.instabug.library.model.Report;
import com.instabug.library.model.common.Session;
import com.instabug.library.model.v3Session.IBGInMemorySession;
import com.instabug.library.model.v3Session.IBGSessionMapper;
import com.instabug.library.sessionV3.configurations.IBGSessionCrashesConfigurations;
import com.instabug.library.sessionV3.di.a;
import com.instabug.library.sessionV3.sync.SessionBatchingFilter;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.tracking.ComposeLifeCycleMonitor;
import com.instabug.library.tracking.InstabugInternalTrackingDelegate;
import com.instabug.library.user.e;
import com.instabug.library.util.BitmapUtils;
import com.instabug.library.util.FileUtils;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.visualusersteps.TouchedViewExtractor;
import com.instabug.library.visualusersteps.n;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;

public class InstabugCore {
    private static boolean isApmPluginNotLoaded = false;
    private static boolean isCrashPluginNotLoaded = false;

    public static boolean isFeaturesFetchedBefore() {
        return d.d().i();
    }

    public static Feature.State getFeatureState(String feature) {
        String string2;
        return d.d().b((Object)string2);
    }

    public static boolean isFeatureAvailable(String feature) {
        String string2;
        return d.d().c((Object)string2);
    }

    public static boolean isFeatureAvailablePersistable(String feature) {
        String string2;
        return d.d().e(string2);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static boolean isDatabaseTransactionDisabled() {
        return d.d().h();
    }

    public static boolean isExperimentalFeatureAvailable(String feature) {
        String string2;
        return d.d().d(string2);
    }

    @Nullable
    public static LinkedHashMap<Uri, String> getExtraAttachmentFiles() {
        return SettingsManager.getInstance().getExtraAttachmentFiles();
    }

    public static String getSDKVersion() {
        return "16.0.1";
    }

    public static int getStartedActivitiesCount() {
        return CoreServiceLocator.getStartedActivitiesCounter().getCount();
    }

    public static void startVitalComponents(@Nullable Application application) {
        if (application != null) {
            Application application2;
            Application application3 = application2;
            InstabugApplicationProvider.init(application3);
            InstabugInternalTrackingDelegate.init(application3);
            return;
        }
    }

    public static int getPrimaryColor() {
        return SettingsManager.getInstance().getPrimaryColor();
    }

    public static InstabugColorTheme getTheme() {
        return SettingsManager.getInstance().getTheme();
    }

    public static String getIdentifiedUserEmail() {
        return e.f();
    }

    @Nullable
    public static String getEnteredEmail() {
        return e.d();
    }

    public static void setEnteredEmail(String enteredEmail) {
        e.e(enteredEmail);
    }

    @Nullable
    public static String getIdentifiedUsername() {
        return e.g();
    }

    public static String getUserData() {
        return SettingsManager.getInstance().getUserData();
    }

    public static void setIdentifiedUserEmail(String userEmail) {
        e.g(userEmail);
    }

    public static void setEnteredUsername(String enteredUsername) {
        e.f(enteredUsername);
    }

    @Nullable
    public static String getEnteredUsername() {
        return e.e();
    }

    @Nullable
    public static OnSdkInvokedCallback getOnSdkInvokedCallback() {
        return SettingsManager.getInstance().getOnSdkInvokedCallback();
    }

    public static String getTagsAsString() {
        return SettingsManager.getInstance().getTagsAsString();
    }

    public static void setLastContactedAt(long time) {
        long l2;
        SettingsManager.getInstance().setLastContactedAt(l2);
    }

    public static boolean isUserLoggedOut() {
        return SettingsManager.getInstance().isUserLoggedOut();
    }

    public static boolean isForegroundBusy() {
        boolean bl = SettingsManager.getInstance().isRequestPermissionScreenShown();
        boolean bl2 = SettingsManager.getInstance().isOnboardingShowing();
        boolean bl3 = c.i();
        return SettingsManager.getInstance().isPromptOptionsScreenShown() || bl || bl2 || bl3;
        {
        }
    }

    @WorkerThread
    public static boolean isForegroundNotBusy() {
        return !SettingsManager.getInstance().isPromptOptionsScreenShown() && !SettingsManager.getInstance().isRequestPermissionScreenShown() && !SettingsManager.getInstance().isOnboardingShowing() && !c.b();
    }

    /*
     * WARNING - void declaration
     */
    public static void setFeatureState(String feature, Feature.State state) {
        void var1_1;
        String string2;
        d.d().a(string2, (Feature.State)var1_1);
    }

    public static int getSessionCount() {
        return SettingsManager.getInstance().getSessionsCount();
    }

    public static long getFirstRunAt() {
        return SettingsManager.getInstance().getFirstRunAt().getTime();
    }

    public static Plugin getXPlugin(Class clazz) {
        return c.a(clazz);
    }

    public static boolean isAppOnForeground() {
        return SettingsManager.getInstance().isAppOnForeground();
    }

    @Nullable
    public static Activity getTargetActivity() {
        return InstabugInternalTrackingDelegate.getInstance().getTargetActivity();
    }

    @Nullable
    public static Object getLastSeenView() {
        return InstabugInternalTrackingDelegate.getInstance().getLastSeenView();
    }

    public static boolean isFeatureEnabled(String feature) {
        String string2;
        return d.d().b((Object)string2) == Feature.State.ENABLED;
    }

    public static void setPushNotificationState(Feature.State state) {
        Feature.State state2;
        d.d().a("PUSH_NOTIFICATION", state2);
    }

    public static void setBugReportingState(Feature.State state) {
        Feature.State state2;
        d.d().a("BUG_REPORTING", state2);
        if (state == Feature.State.DISABLED) {
            AutoScreenRecordingEventBus.getInstance().post(ScreenRecordingServiceAction.CustomeActions.STOP_DELETE);
            return;
        }
        InternalAutoScreenRecorderHelper.getInstance().start();
    }

    public static void setMessagingState(Feature.State state) {
        Feature.State state2;
        d.d().a("IN_APP_MESSAGING", state2);
    }

    public static void setRepliesState(Feature.State state) {
        Feature.State state2;
        d.d().a("REPLIES", state2);
    }

    public static boolean encryptBeforeMarshmallow(@NonNull String filePath) {
        if (Build.VERSION.SDK_INT < 23) {
            String string2;
            return InstabugCore.encrypt(string2);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean encrypt(@NonNull String filePath) {
        void var0_3;
        try {
            return FileUtils.encryptFile(filePath);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        InstabugSDKLogger.e("IBG-Core", "Can't Encrypt attachment", (Throwable)var0_3);
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean decrypt(@NonNull String filePath) {
        void var0_3;
        try {
            return FileUtils.decryptFile(filePath);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        InstabugSDKLogger.e("IBG-Core", "Can't Decrypt attachment", (Throwable)var0_3);
        return false;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ProcessedBytes decryptOnTheFly(String filePath) {
        void var0_3;
        block5: {
            Object object;
            try {
                if (FileUtils.isEncryptedFile(filePath)) {
                    return FileUtils.decryptOnTheFly((String)object);
                }
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                break block5;
            }
            catch (Exception exception) {
                break block5;
            }
            File file = new File((String)object);
            byte[] byArray = new byte[(int)file.length()];
            object = byArray;
            {
                FileUtils.read(file, byArray);
                return new ProcessedBytes((byte[])object, true);
            }
        }
        InstabugSDKLogger.e("IBG-Core", "Can't Decrypt attachment", (Throwable)var0_3);
        return new ProcessedBytes(new byte[0], false);
    }

    public static void setAutoScreenRecordingEnabled(boolean autoScreenRecordingEnabled) {
        boolean bl;
        SettingsManager.getInstance().setAutoScreenRecordingEnabled(bl);
    }

    public static boolean isAutoScreenRecordingEnabled() {
        return SettingsManager.getInstance().isAutoScreenRecordingEnabled();
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends Plugin> void setPluginState(Class<T> clazz, int state) {
        Plugin plugin = InstabugCore.getXPlugin(clazz);
        if (plugin != null) {
            void var1_1;
            plugin.setState((int)var1_1);
            return;
        }
    }

    public static long getLastSeenTimestamp() {
        return SettingsManager.getInstance().getLastSeenTimestamp();
    }

    public static void setLastSeenTimestamp(long currentTimeMillis) {
        long l2;
        SettingsManager.getInstance().setLastSeenTimestamp(l2);
    }

    public static void setInitialScreenShotAllowed(boolean initialScreenShotAllowed) {
        SettingsManager.setInitialScreenShotAllowed(initialScreenShotAllowed);
    }

    public static void isInitialScreenShotAllowed() {
        SettingsManager.isInitialScreenShotAllowed();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static HashMap<String, String> retrieveAllSDKAttributes() {
        return UserAttributeCacheManager.retrieveAllSDKAttributes();
    }

    @NonNull
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static com.instabug.library.internal.servicelocator.c getApplicationScopeServiceLocator() {
        return b.a();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static void doOnBackground(@NonNull Runnable runnable) {
        Runnable runnable2;
        if (runnable == null) {
            return;
        }
        ActionsOrchestrator.obtainOrchestrator().addWorkerThreadAction(new Action(){

            @Override
            public void run() {
                runnable2.run();
            }
        }).orchestrate();
    }

    public static boolean isFirstRunAfterEncryptorUpdate() {
        return SettingsManager.getInstance().isFirstRunAfterEncryptorUpdate();
    }

    public static void setFirstRunAfterEncryptorUpdate(boolean isFirstRun) {
        boolean bl;
        SettingsManager.getInstance().setFirstRunAfterEncryptorUpdate(bl);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static void setPushNotificationToken(String token) {
        SettingsManager.setPushNotificationToken(token);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static String getPushNotificationToken() {
        return SettingsManager.getPushNotificationToken();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static void setPushNotificationTokenSent(boolean isSent) {
        SettingsManager.setPushNotificationTokenSent(isSent);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static boolean isPushNotificationTokenSent() {
        return SettingsManager.isPushNotificationTokenSent();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static boolean isUsersPageEnabled() {
        return SettingsManager.getInstance().isUsersPageEnabled();
    }

    @Nullable
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static Session getRunningSession() {
        Session session = a.x().a();
        if (session != null) {
            return session;
        }
        return h.e().c();
    }

    @Nullable
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static String getLatestV3SessionId() {
        return com.instabug.library.sessionV3.manager.a.a.i();
    }

    @Nullable
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static IBGInMemorySession getRunningV3Session() {
        return com.instabug.library.sessionV3.manager.a.a.e();
    }

    @Nullable
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static IBGInMemorySession getLatestV3Session() {
        return com.instabug.library.sessionV3.manager.a.a.h();
    }

    @Nullable
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static String getLatestSessionReplayId() {
        IBGInMemorySession iBGInMemorySession = InstabugCore.getLatestV3Session();
        if (iBGInMemorySession != null && Instabug.getAppToken() != null) {
            return IBGSessionMapper.INSTANCE.getCompositeSessionId(iBGInMemorySession, Instabug.getAppToken());
        }
        return null;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static IBGSessionCrashesConfigurations getV3SessionCrashesConfigurations() {
        return a.r();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public static void setTemporaryDisabled() {
        InstabugSDKLogger.d("IBG-Core", "setTemporaryDisabled disable the SDK internally");
        d.d().m();
        Method method = f.b(Instabug.class, "disableInternal");
        if (method != null) {
            try {
                method.invoke(null, null);
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            return;
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static String getCurrentView() {
        int n2 = SettingsManager.getInstance().getCurrentPlatform();
        if (n2 != 4 && n2 != 8 && n2 != 7) {
            return CoreServiceLocator.getActiveScreenEvaluator().a(CoreServiceLocator.getScreensRoot());
        }
        return com.instabug.library.tracking.h.b().a();
    }

    @Nullable
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static Report.OnReportCreatedListener getOnReportCreatedListener() {
        return SettingsManager.getInstance().getOnReportCreatedListener();
    }

    @Platform
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static int getPlatform() {
        return SettingsManager.getInstance().getCurrentPlatform();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static boolean isAPMEnabled() {
        block4: {
            if (isApmPluginNotLoaded) {
                return false;
            }
            Plugin plugin = c.a(Class.forName("com.instabug.apm.APMPlugin"));
            if (plugin == null) break block4;
            try {
                return plugin.isFeatureEnabled();
            }
            catch (ClassNotFoundException classNotFoundException) {
                InstabugSDKLogger.v("IBG-Core", "APM Plugin Not Loaded");
                isApmPluginNotLoaded = true;
            }
        }
        return false;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static boolean isCrashReportingEnabled() {
        block4: {
            if (isCrashPluginNotLoaded) {
                return false;
            }
            Plugin plugin = c.a(Class.forName("com.instabug.crash.CrashPlugin"));
            if (plugin == null) break block4;
            try {
                return plugin.isFeatureEnabled();
            }
            catch (ClassNotFoundException classNotFoundException) {
                InstabugSDKLogger.v("IBG-Core", "Crash Plugin Not Loaded");
                isCrashPluginNotLoaded = true;
            }
        }
        return false;
    }

    public static Locale getLocale(@Nullable Context context) {
        Context context2;
        return SettingsManager.getInstance().getInstabugLocale(context2);
    }

    public static int getEncryptorVersion() {
        com.instabug.library.settings.d d2 = com.instabug.library.settings.d.r();
        if (d2 != null) {
            return d2.g();
        }
        return 1;
    }

    public static void saveEncryptorVersion(int version) {
        com.instabug.library.settings.d d2 = com.instabug.library.settings.d.r();
        if (d2 != null) {
            int n2;
            d2.c(n2);
            return;
        }
    }

    public static Feature.State getEncryptionState() {
        return SettingsManager.getInstance().getFeatureState("ENCRYPTION", false);
    }

    public static long getFirstSeen() {
        return SettingsManager.getInstance().getFirstSeen();
    }

    /*
     * WARNING - void declaration
     */
    public static void reportError(Throwable error, String message) {
        void var1_1;
        IBGDiagnostics.reportNonFatal(error, (String)var1_1);
    }

    public static boolean isDbEncryptionEnabled() {
        return d.d().b() == Feature.State.ENABLED;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static boolean canPrintLog(int logLevel) {
        int n2;
        int n3 = SettingsManager.getInstance().getLogLevel();
        return n3 != 0 && n2 <= n3;
    }

    public static boolean isLastSDKStateEnabled(@NonNull Context context) {
        Context context2;
        return new com.instabug.library.settings.b(context2).c();
    }

    public static void cleanVisualUserSteps() {
        CoreServiceLocator.getReproStepsProxy().clean();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static boolean isV3SessionEnabled() {
        return a.q().g();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static void notifyV3SessionDataReadiness(SessionBatchingFilter batchingFilter) {
        SessionBatchingFilter sessionBatchingFilter;
        a.A().a(sessionBatchingFilter);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static void forceV3SessionsEvaluation(SessionBatchingFilter batchingFilter) {
        SessionBatchingFilter sessionBatchingFilter;
        com.instabug.library.sessionV3.sync.c.a.a(sessionBatchingFilter);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static ComposeLifeCycleMonitor getComposeLifeCycleMonitor() {
        return CoreServiceLocator.getComposeLifeCycleMonitor();
    }

    public static void handlePbiFooter(@Nullable View view) {
        com.instabug.library.util.n.a(view);
    }

    /*
     * WARNING - void declaration
     */
    public static void handlePbiFooterThemeColor(@Nullable View view, @ColorRes int lightColor, @ColorRes int darkColor) {
        void var2_2;
        void var1_1;
        Object object = (int)var1_1;
        com.instabug.library.util.n.a(view, (Integer)object, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static void setPbiFooterThemeColor(@Nullable View view, @ColorInt int targetColor) {
        void var1_1;
        com.instabug.library.util.n.a(view, (int)var1_1);
    }

    public static boolean isFullScreen() {
        return SettingsManager.getInstance().isFullscreen();
    }

    public static void setTouchedViewExtractorExtension(TouchedViewExtractor viewExtractor) {
        CoreServiceLocator.setTouchedViewExtractorExtension(viewExtractor);
    }

    @Nullable
    public static Uri saveDrawable(Drawable drawable2) {
        try {
            return BitmapUtils.saveDrawableBitmap(drawable2, System.currentTimeMillis());
        }
        catch (Throwable throwable) {
            IBGDiagnostics.reportNonFatalAndLog(throwable, "something went wrong while saving drawable into file", "IBG-Core");
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public static String composeProminentLabelFor(@Nullable String text, boolean withIcon) {
        void var1_1;
        String string2;
        return n.b().a(string2, (boolean)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static String composeProminentLabelForViewGroup(@NonNull ViewGroup viewGroup, @NonNull String template) {
        void var1_1;
        ViewGroup viewGroup2;
        return new com.instabug.library.visualusersteps.f(viewGroup2, (String)var1_1).a();
    }

    public static void setVideoRecordingButtonPosition(InstabugVideoRecordingButtonPosition videoRecordingButtonPosition) {
        InstabugVideoRecordingButtonPosition instabugVideoRecordingButtonPosition;
        SettingsManager.getInstance().setVideoRecordingButtonPosition(instabugVideoRecordingButtonPosition);
    }

    public static InstabugInvocationEvent[] getInvocationEvents() {
        InstabugInvocationEvent[] instabugInvocationEventArray = SettingsManager.getInstance().getInstabugInvocationEvents();
        if (instabugInvocationEventArray != null) {
            InstabugInvocationEvent[] instabugInvocationEventArray2 = (InstabugInvocationEvent[])instabugInvocationEventArray.clone();
            com.instabug.library.settings.c.o().c();
            return instabugInvocationEventArray2;
        }
        return new InstabugInvocationEvent[]{InstabugInvocationEvent.SHAKE};
    }

    @NonNull
    public static ArrayList<PluginPromptOption> getPluginsPromptOptions() {
        return c.g();
    }

    @Nullable
    public static String getLastAppVersion() {
        return SettingsManager.getInstance().getLastAppVersion();
    }
}

