package com.instabug.library.visualusersteps;

import androidx.annotation.NonNull;

/**
 Created by Barakat on 11/06/2019
 */

/**
 A model that holds {@link android.widget.TextView} value and the top-left point coordinate
 */
public class LabelFrame implements Comparable<LabelFrame>{
    private String text;
    private float left, top;

    public LabelFrame(String text, float top, float left) {
        this.text = text;
        this.left = left;
        this.top = top;
    }

    public float getLeft() {
        return left;
    }

    public float getTop() {
        return top;
    }

    public String getText() {
        return text;
    }

    /**
     A method calculates the distance between the top-left point of a {@link LabelFrame}
     [{@code getTop}, {@code getLeft}] and the top-left point of the window [0, 0]
     based on Pythagorean theorem of the right angel triangle
     */
    private float getDiagonalDistance() {
        return (float) Math.sqrt(getTop() * getTop() + getLeft() * getLeft());
    }

    /**
     Compares a {@link LabelFrame} to another based the {@code getDiagonalDistance} to sort them
     by the nearest to the most top left point of the window [0, 0]
     */
    @Override
    public int compareTo(@NonNull LabelFrame obj) {
        if (getDiagonalDistance() > obj.getDiagonalDistance()) {
            return 1;
        } else if (getDiagonalDistance() < obj.getDiagonalDistance()) {
            return -1;
        }
        return -1;
    }
}
