package com.instabug.library.util.threading

import com.instabug.library.apichecker.ReturnableRunnable
import java.util.concurrent.Callable
import java.util.concurrent.ExecutionException
import java.util.concurrent.ThreadPoolExecutor


fun <T> ThreadPoolExecutor.executeAndGet(runnable: ReturnableRunnable<T>): T? {
    return try {
        val future = submit(Callable {
            try {
                return@Callable runnable.run()
            } catch (e: Throwable) {
                defensiveLog(e)
                if (e is OutOfMemoryError) {
                    reportOOM(e)
                }
            }
            return@Callable null
        })
        future.get()
    } catch (e: ExecutionException) {
        e.printStackTrace()
        null
    } catch (e: InterruptedException) {
        e.printStackTrace()
        null
    }
}

fun PoolProvider.schedule(timeInMills: Long, runnable: Runnable) =
    PoolProvider.postDelayedTask(runnable, timeInMills)