package com.instabug.library.util.threading

import android.os.Process
import com.instabug.library.apichecker.ReturnableRunnable
import com.instabug.library.util.extenstions.logVerbose
import java.util.concurrent.BlockingQueue
import java.util.concurrent.Callable
import java.util.concurrent.ExecutionException
import java.util.concurrent.LinkedBlockingQueue
import java.util.concurrent.ThreadFactory
import java.util.concurrent.TimeUnit

// fixme name the threads for better debugging
open class ReturnableSingleThreadExecutor @JvmOverloads constructor(
    private val identifier: String,
    keepAliveTime: Long = 60,
    unit: TimeUnit = TimeUnit.SECONDS,
    workQueue: BlockingQueue<Runnable> = LinkedBlockingQueue(),
    threadFactory: ThreadFactory = PriorityThreadFactory(
        identifier,
        Process.THREAD_PRIORITY_BACKGROUND
    )
) : SingleThreadPoolExecutor(identifier, keepAliveTime, unit, workQueue, threadFactory) {
    open fun <T> executeAndGet(runnable: ReturnableRunnable<T>?): T? {
        return try {
            val future = submit(Callable {
                try {
                    return@Callable runnable?.run()
                } catch (e: Throwable) {
                    defensiveLog(e)
                    if (e is OutOfMemoryError) {
                        reportOOM(e)
                    }
                }
                return@Callable null
            })
            future.get()
        } catch (e: ExecutionException) {
            defensiveLog(e)
            null
        } catch (e: InterruptedException) {
            "Future task submitted to Exec#$identifier has bee interrupted".logVerbose()
            null
        } catch (e: OutOfMemoryError) {
            null
        }
    }
}