package com.instabug.library.util.threading;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;

import io.reactivexport.annotations.NonNull;

public class HandlerThreadProvider {
    /**
     * This method is used for creating a handler thread to run work.
     * <p>
     * Used to executer work directly instead of waiting in a large thread pool.
     *
     * @param name     handler thread name
     * @param runnable runnable to debounce
     */
    public static void run(@NonNull String name, @NonNull Runnable runnable) {
        HandlerThread handlerThread = new HandlerThread(name);
        handlerThread.start();
        Looper looper = handlerThread.getLooper();
        Handler handler = new Handler(looper);
        handler.post(runnable);
    }
}
