package com.instabug.library.util.extenstions

import com.instabug.library.Constants
import com.instabug.library.core.InstabugCore
import com.instabug.library.util.InstabugSDKLogger

inline fun <T1, T2> T1.runOrLogError(
    tag: String = Constants.LOG_TAG,
    errorMessage: String? = null,
    function: T1.() -> T2
) = kotlin
    .runCatching { function() }
    .onFailure { e ->
        val message = constructErrorMessage(errorMessage, e)
        InstabugCore.reportError(e, message)
        InstabugSDKLogger.e(tag, message, e)
    }

fun constructErrorMessage(errorMessage: String?, e: Throwable) = errorMessage
    ?.plus(e.message.orEmpty())
    ?: e.message.orEmpty()

fun logWarning(
    errorMessage: String,
    tag: String = Constants.LOG_TAG,
) {
    InstabugSDKLogger.w(tag, errorMessage)
}
inline fun <V1, V2> V1.runOrLogVerbose(
    message: String,
    func: V1.() -> V2
) = kotlin.runCatching { func() }.onFailure { InstabugSDKLogger.v(Constants.LOG_TAG, message) }
