package com.instabug.library.util.collections

class LimitedLinkedHashmap<K, V> : LinkedHashMap<K, V> {
    private val limit: Int


    constructor(limit: Int) {
        this.limit = limit
    }

    constructor(limit: Int, initialCapacity: Int, loadFactor: Float) : super(
        initialCapacity,
        loadFactor
    ) {
        this.limit = limit
    }

    constructor(limit: Int, initialCapacity: Int) : super(initialCapacity) {
        this.limit = limit
    }

    constructor(limit: Int, initialCapacity: Int, loadFactor: Float, accessOrder: Boolean) : super(
        initialCapacity, loadFactor, accessOrder
    ) {
        this.limit = limit
    }

    constructor(limit: Int, m: MutableMap<out K?, out V?>) : super(m) {
        this.limit = limit
    }

    override fun removeEldestEntry(eldest: MutableMap.MutableEntry<K, V>?): Boolean {
        return if (size > limit) true
        else super.removeEldestEntry(eldest)
    }
}