package com.instabug.library.util;

import static com.instabug.library.InstabugCustomTextPlaceHolder.Key;

import android.content.Context;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StringRes;

import com.instabug.library.InstabugCustomTextPlaceHolder;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.settings.SettingsManager;

/**
 * Created by vezikon on 7/5/16.
 */
public class PlaceHolderUtils {

    public static String getPlaceHolder(Key key, String defaultValue) {
        InstabugCustomTextPlaceHolder instabugCustomTextPlaceHolder = SettingsManager.getInstance().getCustomPlaceHolders();
        if (instabugCustomTextPlaceHolder == null)
            return defaultValue;

        String placeHolderCustomString = instabugCustomTextPlaceHolder.get(key);
        if (placeHolderCustomString != null && !placeHolderCustomString.trim().equals(""))
            return placeHolderCustomString;

        return defaultValue;
    }

    @NonNull
    public static String getPlaceHolder(@Nullable Context context, Key key, @StringRes int stringRes) {
        InstabugCustomTextPlaceHolder placeHolders = SettingsManager.getInstance().getCustomPlaceHolders();
        if (placeHolders != null) {
            String customString = placeHolders.get(key);
            if (customString != null && !customString.trim().isEmpty()) return customString;
        }
        return context == null ? "" : LocaleUtils.getLocaleStringResource(InstabugCore.getLocale(context), stringRes, context);
    }
}