package com.instabug.library.util;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.instabug.library.Constants;

/**
 * Created by vezikon on 12/21/15.
 */
public class InstabugAppData {

    @NonNull
    private final PackageManager pm;
    @Nullable
    private ApplicationInfo applicationInfo;

    public InstabugAppData(@NonNull Context context) {
        this.pm = context.getPackageManager();
        String packageName = context.getPackageName();
        try {
            this.applicationInfo = pm.getApplicationInfo(packageName, PackageManager.GET_META_DATA);
        } catch (PackageManager.NameNotFoundException e) {
            String message = e.getMessage();
            InstabugSDKLogger.e(Constants.LOG_TAG, "Error while getting application info", e);
        }
    }

    public String getAppName() {
        return (String) (applicationInfo != null ? pm.getApplicationLabel(applicationInfo) : "(unknown)");
    }

    public int getAppIcon() {
        return applicationInfo == null ? 0 : applicationInfo.icon;
    }
}
