package com.instabug.library.util;

import com.instabug.library.Constants;

import java.io.Closeable;

public class ClosableUtils {

    public static void closeQuietly(Closeable closable) {
        if (closable != null) {
            try {
                closable.close();
            } catch (Throwable e) {
                InstabugSDKLogger.e(Constants.LOG_TAG, "Failed to close " + closable.getClass().getSimpleName(), e);
            }
        }
    }
}
