package com.instabug.library.user;

import android.annotation.SuppressLint;

import androidx.annotation.Nullable;

public class UserEventParam {

    @Nullable
    private String key;
    @Nullable
    private String value;

    @Nullable
    public String getKey() {
        return key;
    }

    public UserEventParam setKey(String key) {
        this.key = key;
        return this;
    }

    @Nullable
    public String getValue() {
        return value;
    }

    public UserEventParam setValue(String value) {
        this.value = value;
        return this;
    }

    @Override
    @SuppressLint("NP_METHOD_PARAMETER_TIGHTENS_ANNOTATION")
    public boolean equals(@Nullable Object userEventParams) {
        if (userEventParams == null) {
            return false;
        } else {
            if (userEventParams instanceof UserEventParam) {
                UserEventParam comparedUserEventParam = (UserEventParam) userEventParams;
                return String.valueOf(comparedUserEventParam.getKey()).equals(String.valueOf(getKey()))
                        && (String.valueOf(comparedUserEventParam.getValue()).equals((String.valueOf(getValue()))));
            } else {
                return false;
            }
        }
    }

    @Override
    public int hashCode() {
        if (getKey() != null && getValue() != null)
            return (getKey() + ": " + getValue()).hashCode();
        else
            return -1;
    }
}
