package com.instabug.library.tracking;

import android.app.Activity;
import android.app.Application;
import android.app.Application.ActivityLifecycleCallbacks;
import android.os.Bundle;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.instabug.library.ui.InstabugDialogActivityBase;

public class CurrentActivityMonitor implements ActivityLifecycleCallbacks {

    public void startMonitoring(Application application) {
        application.registerActivityLifecycleCallbacks(this);
    }

    @Override
    public void onActivityCreated(@NonNull Activity activity, @Nullable Bundle savedInstanceState) {

    }

    @Override
    public void onActivityStarted(@NonNull Activity activity) {
        InstabugInternalTrackingDelegate instance = InstabugInternalTrackingDelegate.getInstance();
        if(instance != null) {
            Activity currentActivity = instance.getCurrentRealActivity();
            if (currentActivity instanceof InstabugDialogActivityBase) {
                currentActivity.finish();
            }
            notifyCurrentActivityChanged(activity);
        }
    }

    @Override
    public void onActivityResumed(@NonNull Activity activity) {
        notifyCurrentActivityChanged(activity);
    }

    private void notifyCurrentActivityChanged(@NonNull Activity activity) {
        InstabugInternalTrackingDelegate instance = InstabugInternalTrackingDelegate.getInstance();
        if (instance != null) {
            instance.setCurrentActivity(activity);
        }
    }

    @Override
    public void onActivityPaused(@NonNull Activity activity) {

    }

    @Override
    public void onActivityStopped(@NonNull Activity activity) {

    }

    @Override
    public void onActivitySaveInstanceState(@NonNull Activity activity, @NonNull Bundle outState) {

    }

    @Override
    public void onActivityDestroyed(@NonNull Activity activity) {

    }
}
