package com.instabug.library.settings

import android.content.Context
import android.content.pm.PackageManager
import android.os.Bundle
import com.instabug.library.Constants
import com.instabug.library.Platform
import com.instabug.library.internal.servicelocator.CoreServiceLocator
import com.instabug.library.util.extenstions.logError

class AndroidManifestSettings private constructor(context: Context) {

    private val metaDataBundle: Bundle? = try {
        context.packageManager.getApplicationInfo(
            context.packageName,
            PackageManager.GET_META_DATA
        ).metaData
    } catch (exception: Exception) {
        "Error while reading Android manifest config".logError(exception, Constants.LOG_TAG)
        null
    }

    val appToken: String? =
        try {
            metaDataBundle?.getString(APP_TOKEN_KEY)
        } catch (exception: Exception) {
            "Error while reading token from Android Manifest".logError(exception, Constants.LOG_TAG)
            null
        }

    fun getCurrentPlatform(@Platform fallback: Int): Int = try {
        metaDataBundle?.getString(IBG_PLATFORM)
            ?.let { CoreServiceLocator.platformMapper.map(it to fallback) } ?: fallback
    } catch (exception: Exception) {
        "Error while reading ibg_platform from Android Manifest".logError(
            exception,
            Constants.LOG_TAG
        )
        fallback
    }

    companion object {
        private const val APP_TOKEN_KEY = "com.instabug.library.application_token"
        private const val IBG_PLATFORM = "com.instabug.library.ibg_platform"

        @Volatile
        private var instance: AndroidManifestSettings? = null

        @JvmStatic
        fun getInstance(context: Context) =
            instance ?: synchronized(AndroidManifestSettings::class.java) {
                instance ?: AndroidManifestSettings(context.applicationContext).also {
                    instance = it
                }
            }
    }
}